define("jira/editor/converter/factories/left-trim", [
    "jira/editor/constants"
], function (
    Constants
) {
    "use strict";

    /**
     * Takes object/instance or constructor of a handler as parameter and:
     * 1) trims the content from the left, if any
     * 2) wrap the first child node into LeftTrim in order to apply the logic for the child (till text node)
     *
     * @param {Function|Object} BaseHandler works for both, constructor and instance
     */
    return function handlerFactory(BaseHandler) {
        var LeftTrim = Object.create(BaseHandler);
        LeftTrim.createChildHandler = function createChildHandler(childNode, childIndex, childrenTotal) {
            var handler = Object.getPrototypeOf(LeftTrim).createChildHandler.call(this, childNode, childIndex, childrenTotal);
            if (0 === childIndex) {
                handler = handlerFactory(handler);
            }
            return handler;
        };
        LeftTrim.processText = function processText() {
            return Object.getPrototypeOf(LeftTrim).processText.call(this)
                .replace(Constants.LEFT_WHITESPACE_MATCHER, "");
        };
        LeftTrim._extractLeftSpaces = function () {};

        return LeftTrim;
    };
});