/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.editor.service;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.contentlinkresolver.ContentLinkResolverDescriptor;
import com.atlassian.jira.plugin.editor.service.Converter;
import com.atlassian.jira.plugin.editor.service.RteEnabledService;
import com.atlassian.jira.plugin.renderer.MacroModuleDescriptor;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class JiraRteEnabledService
implements RteEnabledService {
    private static final PluginPointFunction PLUGIN_POINT_FUNCTION = (moduleDescriptor, module) -> moduleDescriptor;
    private static final String FEATURE_NAME = "jira.richeditor.enforce-legacy-macro";
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final FeatureManager featureManager;
    private static final List<String> SYSTEM_COMPONENTS = ImmutableList.of((Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:anchor", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:code", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:quote", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:noformat", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:panel", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:color", (Object)"com.atlassian.jira.plugin.system.renderers.wiki.macros:loremipsum", (Object)"com.atlassian.bonfire.plugin:bonfire-renderer-component-factory", (Object)"com.atlassian.jira.plugin.wiki.renderercomponentfactories:macrorenderer", (Object)"com.atlassian.jira.plugin.wiki.renderercomponentfactories:blockrenderer", (Object)"com.atlassian.jira.plugin.wiki.renderercomponentfactories:linkrenderer", (Object)"com.atlassian.jira.plugin.wiki.renderercomponentfactories:urlrenderer", (Object[])new String[]{"com.atlassian.jira.plugin.wiki.renderercomponentfactories:camelcaselinkrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:embeddedimagerenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:jiraissuelinkrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:backslashescaperenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:htmlescaperenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:htmlentityrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:dashrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:emoticonrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:embeddedobjectrenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:embeddedunembeddablerenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:strongphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:superscriptphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:subscriptphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:emphasisphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:deletedphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:citationphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:insertedphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:monospacedphraserenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:forcenewlinerenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:newlinerenderer", "com.atlassian.jira.plugin.wiki.renderercomponentfactories:tokenrenderer", "com.atlassian.jira.plugins.jira-editor-plugin:rte-macrorenderer", "com.atlassian.jira.plugin.wiki.contentlinkresolvers:attachment", "com.atlassian.jira.plugin.wiki.contentlinkresolvers:anchor", "com.atlassian.jira.plugin.wiki.contentlinkresolvers:jiraissue", "com.atlassian.jira.plugin.wiki.contentlinkresolvers:userprofile", "com.atlassian.jira.jira-issue-link-remote-jira-plugin:remoteJiraIssueLinkRenderer", "com.atlassian.jira.jira-view-issue-plugin:defaultIssueLinkRenderer", "com.atlassian.jirafisheyeplugin:crucibleIssueLinkRenderer", "com.atlassian.jira.jira-issue-link-confluence-plugin:ConfluenceIssueLinkRenderer", "com.atlassian.jira.plugin.ext.bamboo:build-link-renderer"});

    public JiraRteEnabledService(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport FeatureManager featureManager) {
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.featureManager = featureManager;
    }

    @Override
    public boolean isRteEnabled() {
        return this.isPropertyEnabled("jira.rte.enabled");
    }

    public boolean isLegacyMacroEnforced() {
        return this.featureManager.isEnabled(FEATURE_NAME);
    }

    private boolean isPropertyEnabled(String propertyKey) {
        return this.applicationProperties.getOption(propertyKey);
    }

    @Override
    public List<Converter> getConverters() {
        return (List)this.getRenderingModules().map(ModuleDescriptor::getParams).map(Converter::forParams).filter(Converter::isValid).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public Stream<ModuleDescriptor<?>> getRenderingModules() {
        Stream<ModuleDescriptor<?>> macros = this.getModuleDescriptors(MacroModuleDescriptor.class);
        Stream<ModuleDescriptor<?>> components = this.getModuleDescriptors(RendererComponentFactoryDescriptor.class);
        Stream<ModuleDescriptor<?>> linkResolvers = this.getModuleDescriptors(ContentLinkResolverDescriptor.class);
        return Stream.of(macros, components, linkResolvers).flatMap(Function.identity());
    }

    public Stream<ModuleDescriptor<?>> getModuleDescriptors(Class<? extends AbstractJiraModuleDescriptor> type) {
        return SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(type, PLUGIN_POINT_FUNCTION).stream();
    }

    @Override
    public Stream<ModuleDescriptor<?>> getUnsupportedModules() {
        return this.getRenderingModules().filter(this::isUnsupported);
    }

    public boolean isUnsupported(ModuleDescriptor<?> descriptor) {
        return !SYSTEM_COMPONENTS.contains(descriptor.getCompleteKey()) && !Converter.forParams(descriptor.getParams()).isValid();
    }
}

