AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-commit-panel-resources");

(function() {

    module("JIRA.DevStatus.CommitModel", {
    });

    var assertSet = function(actualArray, expectedArray, msg) {
        ok(_.difference(actualArray, expectedArray).length === 0 && _.difference(expectedArray, actualArray).length === 0, msg + " " + JSON.stringify(actualArray) + " is the same as " + JSON.stringify(expectedArray) + "");
    },
    assertDataObject = function(actualObject, expectedObject, msgPrefix) {
        //equal(_.keys(actualObject).length, 2 + (excludeLastUpdated ? 0 : 1), msgPrefix + " correct number of fields");
        assertSet(_.keys(actualObject), _.keys(expectedObject), msgPrefix + " correct fields");
        equal(actualObject.count, expectedObject.count, msgPrefix + " count");
        assertSet(actualObject.commits, expectedObject.commits, msgPrefix + " commits");
        equal(actualObject.lastUpdated, expectedObject.lastUpdated, msgPrefix + " lastUpdated");
    };

    var updateAggregateDataTestCases = [
        {
            name: "null",
            input: null,
            expected: {
                byInstanceType: {},
                overall: {count: 0}
            }
        },
        {
            name: "no summary",
            input: {},
            expected: {
                byInstanceType: {},
                overall: {count: 0}
            }
        },
        {
            name: "no matching type id",
            input: { summary : {
                pullrequest: {
                    byInstanceType: {
                        "stash" : {
                            count: 7, name: "Stash"
                        },
                        "fecru" : {
                            count: 5, name: "FeCru"
                        }
                    },
                    overall: {
                        count: 11, lastUpdated: 1379650519000
                    }
                }
            }},
            expected: {
                byInstanceType: {},
                overall: {count: 0}
            }
        },
        {
            name: "with matching type id",
            input: { summary : {
                repository: {
                    byInstanceType: {
                        "stash" : {
                            count: 7, name: "Stash"
                        },
                        "fecru" : {
                            count: 5, name: "FeCru"
                        }
                    },
                    overall: {
                        count: 11, lastUpdated: 1379650519000
                    }
                }
            }},
            expected: {
                byInstanceType: {
                    "stash" : {
                        count: 7, name: "Stash"
                    },
                    "fecru" : {
                        count: 5, name: "FeCru"
                    }
                },
                overall: {
                    count: 11, lastUpdated: 1379650519000
                }
            }
        },
        {
            name: "with matching type id with errors",
            input: { summary : {
                repository: {
                    byInstanceType: {
                        "stash" : {
                            count: 7, name: "Stash"
                        },
                        "fecru" : {
                            count: 5, name: "FeCru"
                        }
                    },
                    overall: {
                        count: 11, lastUpdated: 1379650519000
                    }
                }
            }, errors : [
                { instance: {name: "name 1", baseUrl: "#"}, data: {}},
                { instance: {name: "name e1", baseUrl: "#"}, error: "e"},
                { instance: {name: "name e2", baseUrl: "#"}, error: "e"},
                { instance: {name: "name 2", baseUrl: "#"}, data: {}},
                { instance: {name: "name e3", baseUrl: "#"}, error: "e"}
            ]},
            expected: {
                byInstanceType: {
                    "stash" : {
                        count: 7, name: "Stash"
                    },
                    "fecru" : {
                        count: 5, name: "FeCru"
                    }
                },
                overall: {
                    count: 11, lastUpdated: 1379650519000
                }
            }
        }
    ];

    _.each(updateAggregateDataTestCases, function(testCase) {
        test("updateData: " + testCase.name, function() {
            var model = new JIRA.DevStatus.CommitModel({});
            model.updateData(testCase.input);
            var actualByInstanceType = model.get('byInstanceType');
            var actualKeys = _.keys(actualByInstanceType);
            equal(actualKeys.length, _.keys(testCase.expected.byInstanceType).length, testCase.name + " byInstanceType has correct number of instance type");
            for (var i = 0; i < actualKeys.length; i++) {
                var expectedObject = testCase.expected.byInstanceType[actualKeys[i]];
                ok(expectedObject, testCase.name + i + " has expected instance type '" +actualKeys[i] + "'");
                assertDataObject(actualByInstanceType[actualKeys[i]], expectedObject, testCase.name + i);
            }
            assertDataObject(model.get("overall"), testCase.expected.overall, testCase.name + " overall");
        });
    });
})();