AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.SummaryTransitionView",{setup:function(){this.sandbox=sinon.sandbox.create();this.fixture=AJS.$("#qunit-fixture");this.createView();this.mockDefer=JIRA.DevStatus.QunitTestUtils.mockDefer()},createView:function(){this.panel=AJS.$("<div></div>").appendTo(this.fixture);this.model={getOverall:this.sandbox.stub(),getPreviousOverall:this.sandbox.stub()};this.view=new JIRA.DevStatus.SummaryTransitionView({el:this.panel,model:this.model});this.view._startSlideDownTransition=this.sandbox.stub();this.view._startRollTransition=this.sandbox.stub()},sampleRollingContent:function(a){return AJS.$("<div class='rolling-container'><div class='rolling-content'><span>"+a+"</span></div></div>")},sampleSlideContent:function(c,a){var b=AJS.$("<div class='sliding-container'><span>"+c+"</span></div>");b.height(a);return b},teardown:function(){this.sandbox.restore();this.mockDefer.restore()}});test("Render slide down transition if old data doesnt exist",function(){var a=this.sampleRollingContent("new");this.view.renderVisible(a);ok(this.view._startSlideDownTransition.calledWith(this.panel,0),"The panel is set to start a slide down transition")});test("Render rolling transition if old data exist",function(){this.panel.html(this.sampleRollingContent("old"));this.model.getPreviousOverall.returns({count:1});var a=this.sampleRollingContent("new");this.view.renderVisible(a);equal(this.panel.find(".old-content").text(),"old","Old content is appended to the container");equal(this.panel.find(".rolling-content").children().eq(0).text(),"new","New content is positioned before the old content");ok(this.view._startRollTransition.called,"The panel is set to start a rolling transition")});test("Doesn't render rolling transition if data has not changed",function(){this.panel.html(this.sampleRollingContent("old"));this.model.getPreviousOverall.returns({count:1});this.model.getOverall.returns({count:1});var a=this.sampleRollingContent("new");this.view.renderVisible(a);ok(!this.view._startRollTransition.called,"The panel is NOT set to start a rolling transition");equal(this.panel.find(".old-content").length,0,"There is no old content");equal(this.panel.find(".rolling-content").text(),"new","Contents are still being rendered")});test("Old data is appended correctly to new containers",function(){var b=AJS.$("<div></div>");b.append(this.sampleRollingContent("1"));b.append(this.sampleRollingContent("2"));b.append(this.sampleRollingContent("3"));var a=AJS.$("<div></div>");a.append(this.sampleRollingContent("4"));a.append(this.sampleRollingContent("5"));a.append(this.sampleRollingContent("6"));this.view._prepareContentsForTransition(a,b);equal(a.find(".rolling-container").length,3,"There are 3 rolling containers");var c=a.find(".rolling-content");equal(c.length,3,"There are 3 rolling contents too");equal(c.eq(0).text(),"41");equal(c.eq(1).text(),"52");equal(c.eq(2).text(),"63");equal(a.find(".old-content").length,3,"There are 3 old contents as well")});test("Height for sliding containers are correctly set to jQuery data",function(){var b=AJS.$("<div></div>");b.append(this.sampleSlideContent("1",11));b.append(this.sampleSlideContent("2",22));b.append(this.sampleSlideContent("3",33));this.panel.html(b);this.model.getPreviousOverall.returns({count:1});var a=AJS.$("<div></div>");a.append(this.sampleSlideContent("4",4));a.append(this.sampleSlideContent("5",5));a.append(this.sampleSlideContent("6",6));this.view.renderVisible(a);var c=this.panel.find(".sliding-container");equal(c.length,3,"There are 3 sliding containers");equal(c.eq(0).data("prevHeight"),11);equal(c.eq(1).data("prevHeight"),22);equal(c.eq(2).data("prevHeight"),33);ok(this.view._startSlideDownTransition.callCount===3,"The inner container in the panel is set to start a slide down transition 3 times");ok(this.view._startSlideDownTransition.getCall(0).args[1]===11);ok(this.view._startSlideDownTransition.getCall(1).args[1]===22);ok(this.view._startSlideDownTransition.getCall(2).args[1]===33)});test("Match up all available elements when 2 different renderings have different number of elements",function(){var b=AJS.$("<div></div>");b.append(this.sampleRollingContent("1"));b.append(this.sampleRollingContent("2"));b.append(this.sampleRollingContent("3"));var a=AJS.$("<div></div>");a.append(this.sampleRollingContent("4"));a.append(this.sampleRollingContent("5"));this.view._prepareContentsForTransition(a,b);equal(a.find(".rolling-container").length,2,"There are 2 rolling containers");var c=a.find(".rolling-content");equal(c.length,2,"There are 3 rolling contents too");equal(c.eq(0).text(),"41");equal(c.eq(1).text(),"52");equal(a.find(".old-content").length,2,"There are 2 old contents as well")});