Backbone.define('JIRA.DevStatus.BaseSummaryModel', Backbone.Model.extend({

    // Child models need to set the typeId
    typeId: undefined,

    properties: [
        "byInstanceType",
        "overall",
        "previousOverall",
        "hasData",
        "dataLoading"
    ],

    /**
     * Sets this model's <code>dataLoading</code> attribute to true.
     */
    startLoadingData: function() {
        this.set('dataLoading', true);
    },

    /**
     * @param aggregatedData Data, or undefined if no data is available.
     */
    updateData: function (aggregatedData) {
        this.set('hasData', aggregatedData !== undefined);
        this.set('dataLoading', false);
        this.set('previousOverall', this.getOverall());

        if (aggregatedData && aggregatedData.summary && aggregatedData.summary[this.typeId]) {
            var summary = aggregatedData.summary[this.typeId];
            this.set('byInstanceType', summary.byInstanceType);
            this.set('overall',summary.overall);
        } else {
            this.set('byInstanceType', {});
            this.set('overall', { count: 0});
        }
    },

    // Needed by the detail dialog
    getType: function () {
        return this.typeId;
    },

    getOverall: function () {
        return this.get("overall");
    },

    /**
     * Retrieves the previous overall values before being replaced by, for example, an ajax update.
     */
    getPreviousOverall: function() {
        return this.get("previousOverall");
    }
}));
