Backbone.define("JIRA.DevStatus.DetailDialogDeploymentView", JIRA.DevStatus.BaseDetailDialogView.extend({
    template: JIRA.Templates.DevStatus.DetailDialog.Deployment.deployment,

    events: {
        "click a.project-link": "_onClickProjectLink",
        "click a.environment-link": "_onClickEnvironmentLink",
        "click a.release-link": "_onClickReleaseLink"
    },

    initialize: function(options) {
        this.analytics = JIRA.DevStatus.DeploymentsAnalytics;
        JIRA.DevStatus.BaseDetailDialogView.prototype.initialize.call(this, _.extend({
            type: "deployment",
            width: 1000,
            height: 400
        }, options));
    },

    renderSuccess: function(applicationType, result) {
        var deploymentProjects = _.reduce(result, function(memo, data) {
            return memo.concat(data.deploymentProjects || []);
        }, []);
        var container = this.getContentContainer(applicationType);
        container.html(this.template({
            applicationType: applicationType,
            deploymentProjects: this.sortProjects(deploymentProjects),
            livestampRelativizeThreshold: this.options.livestampRelativizeThreshold
        }));
        this.renderNoPermissionToViewAllWarningAtBottom(applicationType, this.getEnvironmentCount(deploymentProjects));
        JIRA.DevStatus.Date.addTooltip(container);
        return this;
    },

    getTitle: function(count, issue) {
        return AJS.I18n.getText("devstatus.detail.panel.title.deployment", count, issue);
    },

    getOAuthMessageInFooter: function(instances) {
        return AJS.I18n.getText('devstatus.authentication.message.deployment', instances.length);
    },

    getOAuthMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.authenticate.deployment.title');
    },

    getConnectionMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.connection-problem.deployment.title');
    },

    getNoPermissionToViewAllMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.no-permission-to-view-all.deployment.title');
    },

    hasData: function(detail) {
        return _.reduce(detail, function(memo, data) {
            return memo.concat(data.deploymentProjects || []);
        }, []).length > 0;
    },

    /**
     * Sort projects by most recent environments first, environments remain in order provided by Bamboo
     */
    sortProjects: function(projects) {
        return _.sortBy(projects, function(project) {
            return _.last(_.sortBy(project.environments, function(environment) {
                return new Date(environment.lastDeployed || 0).getTime();
            })).lastDeployed;
        }).reverse();
    },

    /**
     * Calculate the total number of environments in all projects.
     */
    getEnvironmentCount: function (deploymentProjects) {
        return _.union.apply(null, _.map(deploymentProjects, function (project) {
            // project's plan
            return _.pluck(project.environments, 'environmentId');
        })).length;
    },

    _onClickProjectLink: function() {
        JIRA.DevStatus.DeploymentsAnalytics.fireDetailProjectClicked();
    },

    _onClickEnvironmentLink: function() {
        JIRA.DevStatus.DeploymentsAnalytics.fireDetailEnvironmentClicked();
    },

    _onClickReleaseLink: function() {
        JIRA.DevStatus.DeploymentsAnalytics.fireDetailReleaseClicked();
    }
}));
