AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-deployment-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

module("JIRA.DevStatus.DetailDialogDeploymentView", {
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.issueKey = "DEV-1";
        this.issueId = 10000;
        this.server = sinon.fakeServer.create();

        JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Deployments", this.sandbox);
    },
    teardown : function () {
        this.sandbox.restore();
        this.server.restore();
        JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
    },
    getDetailDialog: function() {
        var dialog = AJS.$(".jira-dialog");
        return {
            heading: dialog.find(".devstatus-dialog-heading"),
            content: dialog.find(".devstatus-dialog-content")
        }
    },
    createView: function(summaryCount, dialogCount) {
        return new JIRA.DevStatus.DetailDialogDeploymentView({
            count: summaryCount,
            dataType: "deployment",
            issueKey: this.issueKey,
            tabs: {
                bamboo: {name: "Bamboo", count: dialogCount}
            }
        });
    },
    assertNoNoPermissionMessage: function() {
        ok(this.getDetailDialog().content.find(".no-permission-to-view-all").length === 0, "There is NO no-permission-to-view message");
    },
    assertNoConnectionErrorWarning: function() {
        ok(this.getDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length === 0, "There is NO connection error message");
    },
    assertNoErrorMessagesInCanvas: function() {
        this.assertNoNoPermissionMessage();
        this.assertNoConnectionErrorWarning();
    }
});

test("Test lock screen renders if no data would be displayed", function() {
    var applicationType = 'fecru';
    var data = {detail: [{deploymentProjects: []}] };
    var view = this.createView(7, 7);

    var $fixture = AJS.$('#qunit-fixture');
    $fixture.html('<div id="tab-content-' + applicationType + '"><div class="detail-content-container"></div></div>');
    view.$el = $fixture;
    view.renderSuccess = this.sandbox.spy();
    view._handleFetchSucceeded(applicationType, data);

    ok(view.renderSuccess.neverCalledWith(applicationType, data.detail));
    var contentContainer = view.getContentContainer(applicationType);
    var noPermissionToViewAll = contentContainer.find(".no-permission-to-view-all");
    ok(noPermissionToViewAll.find(".lock-image").length > 0, "has lock image");
    equal(noPermissionToViewAll.text(), "You don't have access to view all related deployments."
            + " Please contact your administrator.");
});

test("Test sorting of projects and environments", function() {
    var view = this.createView(7, 7);
    deepEqual(view.sortProjects([
        {name: 'z', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:00:00.000+0100'},
            {name: 'c'},
            {name: 'b', lastDeployed: '2013-10-22T12:02:00.000+0100'}
        ]},
        {name: 'a', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:00:00.000+0100'}
        ]},
        {name: 'M', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:01:00.000+0100'},
            {name: 'b', lastDeployed: '2013-10-22T12:03:00.000+0100'},
            {name: 'c', lastDeployed: '2013-10-22T12:02:00.000+0100'}
        ]}
    ]), [
        {name: 'M', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:01:00.000+0100'},
            {name: 'b', lastDeployed: '2013-10-22T12:03:00.000+0100'},
            {name: 'c', lastDeployed: '2013-10-22T12:02:00.000+0100'}
        ]},
        {name: 'z', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:00:00.000+0100'},
            {name: 'c'},
            {name: 'b', lastDeployed: '2013-10-22T12:02:00.000+0100'}
        ]},
        {name: 'a', environments: [
            {name: 'a', lastDeployed: '2013-10-22T12:00:00.000+0100'}
        ]}
    ]);
});

test("Test environment count", function() {
    var view = this.createView();
    equal(view.getEnvironmentCount([
    ]), 0, "no projects");
    equal(view.getEnvironmentCount([
        {name: 'a', environments: [
            {environmentId: 1}
        ]}
    ]), 1, "single project, single environment");
    equal(view.getEnvironmentCount([
        {name: 'z', environments: [
            {environmentId: 1},
            {environmentId: 2},
            {environmentId: 3}
        ]}
    ]), 3, "single project, multiple environments");
    equal(view.getEnvironmentCount([
        {name: 'a', environments: [
            {environmentId: 0}
        ]},
        {name: 'z', environments: [
            {environmentId: 1},
            {environmentId: 2},
            {environmentId: 3}
        ]}
    ]), 4, "multiple projects, multiple builds");
});

test("Test dialog title for single deployment environment", function() {
    var view = this.createView(1, 1);

    view.show();
    var dialog = this.getDetailDialog();
    equal(dialog.heading.text(), "DEV-1: 1 deployment")
});

test("Test dialog title for multiple deployment environment", function() {
    var view = this.createView(2, 1);

    view.show();
    var dialog = this.getDetailDialog();
    equal(dialog.heading.text(), "DEV-1: 2 deployments")
});

test("Test deployment detail dialog with success request", function() {
    expect(137);
    JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
    var view = this.createView(5);

    view.show();
    var dialog = this.getDetailDialog();
    var spinner = dialog.content.find(".status-loading");
    var activePane = dialog.content.find(".tabs-pane.active-pane");
    var projects = [
        {
            name: "Deployment Two",
            latestVersionName: "1.1",
            environments: [
                {
                    name: "Integration",
                    status: "Deployed",
                    latestRelease: "1.1-feature",
                    lastDeployed: "2013-11-19"
                },
                {
                    name: "Production",
                    status: "Not deployed",
                    latestRelease: "1.1",
                    lastDeployed: "2013-11-15"
                },
                {
                    name: "Environment with deleted release",
                    status: "Not deployed",
                    latestRelease: "1.2",
                    lastDeployed: "2013-11-15",
                    versionDeleted: true
                }
            ]
        },
        {
            name: "Deployment Two",
            latestVersionName: "1.1",
            environments: [
                {
                    name: "Dogfooding",
                    status: "Deployed",
                    latestRelease: "1.1-feature",
                    lastDeployed: "2013-11-19"
                },
                {
                    name: "Integration",
                    status: "Not deployed",
                    latestRelease: "1.2",
                    lastDeployed: "2013-11-17"
                },
                {
                    name: "Production",
                    status: "Not deployed",
                    latestRelease: "1.1",
                    lastDeployed: "2013-11-15"
                }
            ]
        },
        {
            name: "Deployment One",
            latestVersionName: "release-5",
            environments: [
                {
                    name: "Dogfooding",
                    status: "Failed",
                    latestRelease: "release-5",
                    lastDeployed: "2013-11-19"
                },
                {
                    name: "Integration",
                    status: "Not deployed",
                    latestRelease: "release-3",
                    lastDeployed: "2013-11-17"
                },
                {
                    name: "Production",
                    status: "Not deployed",
                    latestRelease: "release-3",
                    lastDeployed: "2013-11-15"
                }
            ]
        },
        {
            name: "Deployment One",
            latestVersionName: "release-5",
            environments: [
                {
                    name: "Integration",
                    status: "Not deployed",
                    latestRelease: "release-3",
                    lastDeployed: "2013-11-17"
                },
                {
                    name: "Production",
                    status: "Not deployed",
                    latestRelease: "release-3",
                    lastDeployed: "2013-11-15"
                }
            ]
        }
    ];

    ok(spinner.is(":visible"), "A spinner is visible  when there is an onflight ajax request");
    ok(spinner.children().length > 0);
    ok(activePane.hasClass("loading"), "Dialog content is faded out when there is an onflight ajax request");

    AJS.TestContractManager.respondToRequest("detail3LO-bamboo", this.server.requests[0]);
    AJS.TestContractManager.respondToRequest("bambooDetailDeployment-multiple", this.server.requests[1]);

    this.assertNoErrorMessagesInCanvas();

    var deploymentContainers = dialog.content.find(".detail-deployments-container");

    ok(!spinner.is(":visible"), "A spinner is no longer visible when the onflight ajax request has completed");
    ok(!activePane.hasClass("loading"), "Dialog content is no longer faded out when ajax has completed");
    equal(deploymentContainers.length, projects.length, "Number of project tables rendered into the dialog is correct");

    _.each(deploymentContainers, _.bind(function(element, index) {
        var el = AJS.$(element);
        var messagePrefix = "Project[" + index + "]: ";

        var projectLink = el.find(".project-link");
        equal(projectLink.text(), projects[index].name, messagePrefix + "the project name exist and is correct");
        strictEqual(projectLink.attr("target"), undefined, messagePrefix + "clicking on project link opens in the same tab");
        projectLink.click();
        ok(JIRA.DevStatus.DeploymentsAnalytics.fireDetailProjectClicked.called,
           messagePrefix + "analytic event is fired correctly when clicking on project link");
        JIRA.DevStatus.DeploymentsAnalytics.fireDetailProjectClicked.reset();

        var commitInfo = el.find(".commit-info");
        equal(commitInfo.text(), "Commits were in release " + projects[index].latestVersionName, messagePrefix + "commits-from information exist and is correct");

        var environmentList = el.find(".deployments-table tr.environment-row");
        equal(environmentList.length, projects[index].environments.length, messagePrefix + "list of environments exist and contains the correct number of rows");

        _.each(environmentList, _.bind(function(element, environmentRowIndex) {
            var environmentRow = AJS.$(element);
            var messagePrefix = "Project[" + index + "], environment[" + environmentRowIndex + "]: ";
            var expectedEnvironmentData = projects[index].environments[environmentRowIndex];

            var environment = environmentRow.find(".environment");
            var environmentLink = environment.find(".environment-link");
            equal(environmentLink.text(), expectedEnvironmentData.name, messagePrefix + "the environment name exist and is correct");
            strictEqual(environmentLink.attr("target"), undefined, messagePrefix + "clicking on environment link opens in the same tab");
            environmentLink.click();
            ok(JIRA.DevStatus.DeploymentsAnalytics.fireDetailEnvironmentClicked.called,
               messagePrefix + "analytic event is fired correctly when clicking on environment link");
            JIRA.DevStatus.DeploymentsAnalytics.fireDetailEnvironmentClicked.reset();

            var statusLozenge = environmentRow.find(".status .aui-lozenge");
            equal(statusLozenge.text(), expectedEnvironmentData.status, messagePrefix + "the environment status exist and is correct");
            if (expectedEnvironmentData.status === "Deployed") {
                ok(statusLozenge.hasClass("aui-lozenge-success"), "environment status lozenge is green");
            } else {
                ok(!statusLozenge.hasClass("aui-lozenge-success"), "environment status lozenge is not green");
            }

            var release = environmentRow.find(".release");
            if (expectedEnvironmentData.versionDeleted)
            {
                equal(release.text(), expectedEnvironmentData.latestRelease, messagePrefix + "the release name exist and is correct");
                var releaseLink = release.find(".release-link");
                ok(releaseLink.length == 0, messagePrefix + "release link is not present");
            }
            else
            {
                var releaseLink = release.find(".release-link");
                equal(releaseLink.text(), expectedEnvironmentData.latestRelease, messagePrefix + "the release name exist and is correct");
                strictEqual(releaseLink.attr("target"), undefined, messagePrefix + "clicking on release link opens in the same tab");
                releaseLink.click();
                ok(JIRA.DevStatus.DeploymentsAnalytics.fireDetailReleaseClicked.called,
                   messagePrefix + "analytic event is fired correctly when clicking on release link");
                JIRA.DevStatus.DeploymentsAnalytics.fireDetailReleaseClicked.reset();
            }

            var timestamp = environmentRow.find(".timestamp .livestamp");
            ok(timestamp.length != 0, messagePrefix + "time stamp is rendered into the table");
            equal(timestamp.attr("title"), expectedEnvironmentData.lastDeployed, messagePrefix + "tooltip is correctly appended onto the timestamp element");
        }, this));

    }, this));
});