Backbone.define('JIRA.DevStatus.CreateReviewFormDialog', Backbone.View.extend({
    initialize: function (options) {
        this.linkSelector  = options.linkSelector;
        this.applicationType = options.applicationType;
        this.instances = options.instances;

        this.dialog.instance = this;
    },

    renderSuccess: function() {
        AJS.$('.create-review-instance a').attr("href", JIRA.DevStatus.URL.getCreateReviewDetailUrl(this.applicationType));
    },

    _processTargets: function(targets) {
        var self = this,
            mapped = _.map(targets, function(target) {
            var instance = _.find(self.instances, function (instance) {
                return instance.baseUrl === target.baseUrl
            });

            if (!instance) {
                return null;
            }

            return _.extend({}, target, instance);
        });

        return _.sortBy(_.filter(mapped, _.identity), 'name');
    },

    dialog: new JIRA.FormDialog({
            id: 'devstatus-cta-create-review-dialog',
            trigger: '.create-review-instance a',
            width: 560,
            content: function (ready) {
                var instance = this.instance,
                    self = this;
                this.pickerView = new JIRA.DevStatus.InstancePickerView({
                    el: this.$popup,
                    activeTrigger: this.$activeTrigger,
                    cta: 'devstatus.cta.createreview',

                    processTargets: function(targets) {
                        return self.instance._processTargets.call(self.instance, targets);
                    },

                    uniqueResultAction: function(uniqueResult) {
                        JIRA.DevStatus.CommitsAnalytics.fireDetailCreateReviewClicked(instance.applicationType, true);
                        JIRA.DevStatus.Navigate.navigate(uniqueResult.url);
                    }
                });

                this.pickerView.render().always(function(content) {
                    ready(content);
                    AJS.$(self.$popup).find(".primary.target").eq(0).focus();
                    AJS.$('.target').click(function(e) {
                        JIRA.DevStatus.CommitsAnalytics.fireDetailCreateReviewClicked(instance.applicationType, true);
                    });
                });
            },
            autoClose: true
        })
}));