Backbone.define('JIRA.DevStatus.CreateBranchFormDialog', Backbone.View.extend({
    initialize: function (options) {
        AJS.namespace("JIRA.DevStatus.CtaDialog");
        this.parentContainerSelector = options.parentContainerSelector;
        this.panelSelector = options.panelSelector;
        this.linkSelector  = options.linkSelector;
        this.dialogId = 'devstatus-cta-dialog';

        /**
         * Initialise analytics before form dialog to explicitly put analytics event in front of the form dialog events in the queue
         */
        JIRA.DevStatus.CtaDialogAnalytics.initialize(this.parentContainerSelector, this.linkSelector, this.dialogId);
        this._initFormDialog();
    },

    _initFormDialog: function() {
        var instance = this;
        var dialog = JIRA.DevStatus.CtaDialog.dialog = new JIRA.FormDialog({
            id: this.dialogId,
            width: 560,
            content: function (ready) {
                this.pickerView = new JIRA.DevStatus.InstancePickerView({
                    el: this.$popup,
                    activeTrigger: this.$activeTrigger,
                    cta: instance._getCta(this.$activeTrigger)
                });
                this.pickerView.render().always(function(content) {
                    ready(content);
                    AJS.$(dialog.$popup).find(".target").eq(0).focus();
                    //analytics event about the opening of the cta dialog
                    JIRA.DevStatus.CtaDialogAnalytics.fireCreateBranchEvent("dialog.open");
                });
            },
            trigger: this.linkSelector,
            autoClose: true
        });
    },

    _getCta: function(link) {
        /**
         * Look for cta key in the element data first because the URL in IE8/9 contains a '#' for both view issue and agile
         */
        var ctaData = link.data('cta');
        if (ctaData) {
            return ctaData;
        } else {
            var url = link.attr('href'),
                m = url && /\#([a-zA-Z\.]+)/.exec(url);
            return m && m[1];
        }
    }
}));