Backbone.define('JIRA.DevStatus.DevStatusData', Backbone.Model.extend({
    properties: [
        "aggregatedData"
    ],

    namedEvents: [
        "beforeRequest",
        "requestFail",
        "requestSuccess"
    ],

    /**
     * @param options
     * @param options.issueId Id of the currently visible issue
     */
    initialize: function (options) {
        this.issueId = options.issueId;
    },

    retrieveAggregateData: function() {
        var url = AJS.contextPath() + '/rest/dev-status/1.0/issue/summary?issueId=' + this.issueId;

        this.trigger("beforeRequest");
        return AJS.$.ajax(url)
                .done(_.bind(this.setAggregateData, this))
                .fail(_.bind(this.setAggregateDataError, this))
                .promise();
    },

    /**
     * @param {object} aggregateData the aggregated data to be rendered
     * @param {boolean} isCache indicates whether the aggregated data is from cache
     * @param {boolean} isFinal indicates whether this update is final, useful to determine whether the panel will be changed again
     * @return {*}
     */
    setAggregateData: function(aggregateData, isCache, isFinal) {
        this.set("aggregatedData", aggregateData);
        // when calling from ajax.done() callback,
        //  isCache would be the statusText "success": we always want it to be false
        //  isFinal would be the xhr object: we always want it to be true
        this.trigger("requestSuccess", this, isCache === true, !!isFinal);
    },

    /**
     * @param {jqXHR} jqXhr the jqXHR
     * @param {string} status the error text status
     * @return {*}
     */
    setAggregateDataError: function(jqXhr, status) {
        this.set("aggregatedData", undefined);
        this.trigger("requestFail", this, jqXhr);
    }

}));
