/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.util.ProductFilterUtil;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Bundle;

public class AnnotationIndexReader {
    public static List<String> readIndexFile(String resourceFile, Bundle bundle) {
        URL url = bundle.getResource(resourceFile);
        return AnnotationIndexReader.readIndexFile(url);
    }

    public static List<String> readIndexFile(String resourceFile, ClassLoader classLoader) {
        URL url = classLoader.getResource(resourceFile);
        return AnnotationIndexReader.readIndexFile(url);
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, Bundle bundle) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = bundle.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        String productName = ProductFilterUtil.getLowerCurrentProductName();
        if (StringUtils.isNotBlank((String)productName)) {
            entries.addAll(AnnotationIndexReader.readIndexFile(resourceFile + "-" + productName, bundle));
        }
        return entries;
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, ClassLoader classLoader) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = classLoader.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        String productName = ProductFilterUtil.getLowerCurrentProductName();
        if (StringUtils.isNotBlank((String)productName)) {
            entries.addAll(AnnotationIndexReader.readIndexFile(resourceFile + "-" + productName, classLoader));
        }
        return entries;
    }

    public static List<String> readIndexFile(URL url) {
        ArrayList<String> resources = new ArrayList<String>();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            String line = reader.readLine();
            while (line != null) {
                resources.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read index file [" + url.toString() + "]", e);
        }
        return resources;
    }
}

