/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.processor;

import com.atlassian.plugin.spring.scanner.annotation.OnlyInProduct;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang.StringUtils;

public abstract class IndexWritingAnnotationProcessor
extends AbstractProcessor
implements Processor {
    private Map<String, Set<String>> annotatedTypeMap = new HashMap<String, Set<String>>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, String indexKey) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    TypeAndAnnotation typeAndAnnotation = this.getTypeAndAnnotation(element, typeElement);
                    if (null == typeAndAnnotation || null == typeAndAnnotation.getTypeElement()) continue;
                    String lowerFilterName = this.getFilterNameFromAnnotation(typeAndAnnotation.getAnnotation(), indexKey);
                    String nameFromAnnotation = "";
                    try {
                        Annotation componentAnno = typeAndAnnotation.getAnnotation();
                        Method valueMethod = componentAnno.getClass().getDeclaredMethod("value", new Class[0]);
                        nameFromAnnotation = (String)valueMethod.invoke((Object)componentAnno, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    StringBuilder sb = new StringBuilder(typeAndAnnotation.getTypeElement().getQualifiedName().toString());
                    if (StringUtils.isNotBlank((String)nameFromAnnotation)) {
                        sb.append("#").append(nameFromAnnotation);
                    }
                    String typeName = sb.toString();
                    Set<String> typeNames = this.getAnnotatedTypeNames(lowerFilterName);
                    if (typeNames.contains(typeName)) continue;
                    typeNames.add(typeName);
                }
            }
            if (!roundEnv.processingOver()) {
                return;
            }
            this.writeIndexFiles(indexKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract TypeAndAnnotation getTypeAndAnnotation(Element var1, TypeElement var2);

    protected void readOldIndexFile(Set<String> entries, String resourceName, Filer filer) {
        try {
            FileObject resource = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName);
            List<String> lines = this.readResourceIntoLines(resource);
            for (String line : lines) {
                entries.add(line);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> readResourceIntoLines(FileObject resource) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        InputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            fis = resource.openInputStream();
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while (dis.available() != 0) {
                lines.add(dis.readLine());
            }
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != bis) {
                    bis.close();
                }
                if (null != dis) {
                    dis.close();
                }
            }
            catch (IOException ex) {}
        }
        return lines;
    }

    public Map<String, Set<String>> getAnnotatedTypeMap() {
        return this.annotatedTypeMap;
    }

    public Set<String> getAnnotatedTypeNames(String lowerFilterName) {
        if (!this.getAnnotatedTypeMap().containsKey(lowerFilterName)) {
            this.getAnnotatedTypeMap().put(lowerFilterName, new HashSet());
        }
        return this.getAnnotatedTypeMap().get(lowerFilterName);
    }

    protected void writeIndexFiles(String indexKey) throws IOException {
        for (Map.Entry<String, Set<String>> entry : this.getAnnotatedTypeMap().entrySet()) {
            StringBuilder filePath = new StringBuilder("META-INF/plugin-components");
            filePath.append("/").append(indexKey);
            if (!entry.getKey().equals(indexKey)) {
                filePath.append("-").append(entry.getKey());
            }
            this.writeIndexFile((Iterable<String>)entry.getValue(), filePath.toString(), this.processingEnv.getFiler());
        }
    }

    protected void writeIndexFile(Iterable<String> elementNameList, String resourceName, Filer filer) throws IOException {
        HashSet<String> entries = new HashSet<String>();
        for (String elementName : elementNameList) {
            entries.add(elementName);
        }
        this.readOldIndexFile(entries, resourceName, filer);
        FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
        Writer writer = file.openWriter();
        for (String entry : entries) {
            writer.write(entry);
            writer.write("\n");
        }
        writer.close();
    }

    protected String getFilterNameFromAnnotation(Annotation annotation, String indexKey) {
        String filterName = "";
        filterName = annotation.annotationType().isAnnotationPresent(OnlyInProduct.class) ? annotation.annotationType().getAnnotation(OnlyInProduct.class).value().name().toLowerCase() : indexKey;
        return filterName;
    }

    protected class TypeAndAnnotation {
        private final TypeElement typeElement;
        private final Annotation annotation;

        protected TypeAndAnnotation(TypeElement typeElement, Annotation annotation) {
            this.typeElement = typeElement;
            this.annotation = annotation;
        }

        public TypeElement getTypeElement() {
            return this.typeElement;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }
    }
}

