/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.service.exporter.support.AutoExport;
import org.springframework.osgi.service.exporter.support.ExportContextClassLoader;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;

public class ExportedSeviceManager {
    private final Hashtable<Integer, OsgiServiceFactoryBean> exporters = new Hashtable();

    public ServiceRegistration registerService(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, AutoExport autoExport, Class<?> ... interfaces) throws Exception {
        serviceProps.put("org.springframework.osgi.bean.name", beanName);
        OsgiServiceFactoryBean osgiExporter = this.createExporter(bundleContext, bean, beanName, serviceProps, autoExport, interfaces);
        int hashCode = System.identityHashCode(bean);
        this.exporters.put(hashCode, osgiExporter);
        ServiceRegistration reg = (ServiceRegistration)osgiExporter.getObject();
        return reg;
    }

    public void unregisterService(BundleContext bundleContext, Object bean) {
        int hashCode = System.identityHashCode(bean);
        OsgiServiceFactoryBean exporter = this.exporters.get(hashCode);
        if (null != exporter) {
            exporter.destroy();
            this.exporters.remove(hashCode);
        }
    }

    private OsgiServiceFactoryBean createExporter(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, AutoExport autoExport, Class<?> ... interfaces) throws Exception {
        OsgiServiceFactoryBean exporter = new OsgiServiceFactoryBean();
        exporter.setAutoExport(autoExport);
        exporter.setBeanClassLoader(bean.getClass().getClassLoader());
        exporter.setBeanName(beanName);
        exporter.setBundleContext(bundleContext);
        exporter.setContextClassLoader(ExportContextClassLoader.UNMANAGED);
        exporter.setInterfaces((Class[])interfaces);
        exporter.setServiceProperties(serviceProps);
        exporter.setTarget(bean);
        exporter.afterPropertiesSet();
        return exporter;
    }
}

