/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.extension.ClassIndexBeanDefinitionScanner;
import com.atlassian.plugin.spring.scanner.extension.ComponentImportBeanFactoryPostProcessor;
import com.atlassian.plugin.spring.scanner.extension.ServiceExporterBeanPostProcessor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class AtlassianScannerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String AUTO_IMPORTS_ATTRIBUTE = "auto-imports";
    public static final String JAVAX_INJECT_CLASSNAME = "javax.inject.Inject";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean autoImports = false;
        if (element.hasAttribute(AUTO_IMPORTS_ATTRIBUTE)) {
            autoImports = Boolean.parseBoolean(element.getAttribute(AUTO_IMPORTS_ATTRIBUTE));
        }
        ClassIndexBeanDefinitionScanner scanner = new ClassIndexBeanDefinitionScanner(parserContext.getReaderContext().getRegistry());
        Set<BeanDefinitionHolder> beanDefinitions = scanner.doScan();
        this.registerComponents(parserContext.getReaderContext(), beanDefinitions, element, autoImports);
        return null;
    }

    protected void registerComponents(XmlReaderContext readerContext, Set<BeanDefinitionHolder> beanDefinitions, Element element, boolean autoImports) {
        Object source = readerContext.extractSource((Object)element);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), source);
        for (BeanDefinitionHolder beanDefHolder : beanDefinitions) {
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefHolder));
        }
        LinkedHashSet<BeanDefinitionHolder> processorDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        processorDefinitions.addAll(AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)readerContext.getRegistry(), (Object)source));
        BeanDefinitionHolder javaxInject = this.getJavaxInjectPostProcessor(readerContext.getRegistry(), source);
        if (null != javaxInject) {
            processorDefinitions.add(javaxInject);
        }
        processorDefinitions.add(this.getComponentImportPostProcessor(readerContext.getRegistry(), source, autoImports));
        processorDefinitions.add(this.getServiceExportPostProcessor(readerContext.getRegistry(), source));
        for (BeanDefinitionHolder processorDefinition : processorDefinitions) {
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(processorDefinition));
        }
        readerContext.fireComponentRegistered((ComponentDefinition)compositeDef);
    }

    private BeanDefinitionHolder getJavaxInjectPostProcessor(BeanDefinitionRegistry registry, Object source) {
        if (ClassUtils.isPresent((String)JAVAX_INJECT_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
            try {
                Class<?> injectClass = this.getClass().getClassLoader().loadClass(JAVAX_INJECT_CLASSNAME);
                HashMap properties = new HashMap();
                properties.put("autowiredAnnotationType", injectClass);
                RootBeanDefinition def = new RootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class);
                def.setSource(source);
                def.setRole(2);
                def.setPropertyValues(new MutablePropertyValues(properties));
                return this.registerBeanPostProcessor(registry, def, "javaxInjectBeanPostProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanDefinitionHolder registerBeanPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        return new BeanDefinitionHolder((BeanDefinition)definition, beanName);
    }

    private BeanDefinitionHolder getComponentImportPostProcessor(BeanDefinitionRegistry registry, Object source, boolean autoImports) {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        props.put("autoImports", autoImports);
        RootBeanDefinition def = new RootBeanDefinition(ComponentImportBeanFactoryPostProcessor.class);
        def.setAutowireMode(3);
        def.setSource(source);
        def.setPropertyValues(new MutablePropertyValues(props));
        return this.registerBeanPostProcessor(registry, def, "componentImportBeanFactoryPostProcessor");
    }

    private BeanDefinitionHolder getServiceExportPostProcessor(BeanDefinitionRegistry registry, Object source) {
        RootBeanDefinition def = new RootBeanDefinition(ServiceExporterBeanPostProcessor.class);
        def.setSource(source);
        def.setAutowireMode(3);
        return this.registerBeanPostProcessor(registry, def, "serviceExportBeanPostProcessor");
    }
}

