/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web.cta.condition;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.devstatus.api.DevStatusCtaService;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractIssueWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ShowCallToActionCondition
extends AbstractIssueWebCondition {
    static final String CTA_CONFIG_PARAM = "cta";
    private final DevStatusCtaService devStatusCtaService;
    private String cta;

    public ShowCallToActionCondition(DevStatusCtaService devStatusCtaService) {
        this.devStatusCtaService = devStatusCtaService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
        this.cta = params.get(CTA_CONFIG_PARAM);
        if (StringUtils.isBlank((CharSequence)this.cta)) {
            throw new IllegalArgumentException("'cta' parameter is empty or blank: " + this.cta);
        }
    }

    public boolean shouldDisplay(ApplicationUser user, Issue issue, JiraHelper jiraHelper) {
        ServiceOutcome<Boolean> result = this.devStatusCtaService.hasRemoteApps(this.cta, issue, user);
        return result.isValid() && Boolean.TRUE.equals(result.getReturnedValue());
    }
}

