/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary.util;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.plugin.devstatus.summary.util.IterableUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class AggregatorUtils {
    public static int countUnique(Iterable<Pair<Integer, Collection<String>>> countAndValues) {
        HashSet unionValues = Sets.newHashSet();
        int totalFromvaluesizes = 0;
        int totalFromCounts = 0;
        for (Pair<Integer, Collection<String>> values : countAndValues) {
            unionValues.addAll((Collection)values.right());
            totalFromvaluesizes += ((Collection)values.right()).size();
            totalFromCounts += Math.max((Integer)values.left(), ((Collection)values.right()).size());
        }
        return totalFromCounts - (totalFromvaluesizes - unionValues.size());
    }

    public static <T> Option<Date> maxDate(Iterable<T> items, Function<? super T, Date> datePicker) {
        return AggregatorUtils.maxDate(items, datePicker, (Ordering<Comparable>)Ordering.natural());
    }

    public static <T> Option<Date> maxDate(Iterable<T> items, Function<? super T, Date> datePicker, Ordering<Comparable> ordering) {
        Iterable<Date> dates = IterableUtils.transformAndRemoveNull(items, datePicker);
        if (Iterables.isEmpty(dates)) {
            return Option.none();
        }
        return Option.some((Object)ordering.max(dates));
    }
}

