/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.DeploymentEnvironmentObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.DeploymentOverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;

@Named
public class DeploymentEnvironmentAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<DeploymentEnvironmentObject> {
    public static final int MAX_ENVIRONMENTS_IN_PANEL = 3;

    @Override
    public String getType() {
        return DeploymentEnvironmentObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    @Override
    public DeploymentEnvironmentObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(DeploymentEnvironmentObject.class);
    }

    public DeploymentOverallBean aggregateDataObjects(Collection<DeploymentEnvironmentObject> deploymentEnvironments) {
        ArrayListMultimap projects2Environments = ArrayListMultimap.create();
        ArrayList topEnvironments = Lists.newArrayList();
        for (DeploymentEnvironmentObject environment : Iterables.filter(deploymentEnvironments, DeploymentEnvironmentObject.IS_DEPLOYED)) {
            projects2Environments.put((Object)environment.getProjectIdentifier(), (Object)environment);
        }
        if (projects2Environments.keySet().size() == 1) {
            Collection environments = projects2Environments.values();
            int toSkip = Math.max(environments.size() - 3, 0);
            Iterables.addAll((Collection)topEnvironments, (Iterable)Iterables.skip((Iterable)DeploymentEnvironmentObject.ORDERING_BY_POSITION.sortedCopy((Iterable)environments), (int)toSkip));
        } else if (projects2Environments.keySet().size() == 2) {
            int limit = 2;
            for (DeploymentEnvironmentObject.ProjectIdentifier projectIdentifier : DeploymentEnvironmentObject.ProjectIdentifier.ORDERING.sortedCopy((Iterable)projects2Environments.keySet())) {
                Collection environments = projects2Environments.get((Object)projectIdentifier);
                int toSkip = Math.max(environments.size() - limit, 0);
                Iterables.addAll((Collection)topEnvironments, (Iterable)Iterables.skip((Iterable)DeploymentEnvironmentObject.ORDERING_BY_POSITION.sortedCopy((Iterable)environments), (int)toSkip));
                limit = 3 - topEnvironments.size();
            }
        } else {
            for (DeploymentEnvironmentObject.ProjectIdentifier projectIdentifier : Iterables.limit((Iterable)DeploymentEnvironmentObject.ProjectIdentifier.ORDERING.sortedCopy((Iterable)projects2Environments.keySet()), (int)3)) {
                Collection environments = projects2Environments.get((Object)projectIdentifier);
                topEnvironments.add(DeploymentEnvironmentObject.ORDERING_BY_POSITION.max((Iterable)environments));
            }
        }
        return new DeploymentOverallBean(deploymentEnvironments.size(), projects2Environments.values().size(), projects2Environments.keySet().size() > 1, (ImmutableList<DeploymentEnvironmentObject>)ImmutableList.copyOf((Collection)topEnvironments));
    }
}

