/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary;

import com.atlassian.fugue.Option;
import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.SummaryObjectMap;
import com.atlassian.fusion.schema.summary.objects.BuildsObject;
import com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean;
import com.atlassian.jira.plugin.devstatus.summary.Aggregator;
import com.atlassian.jira.plugin.devstatus.summary.AggregatorHelper;
import com.atlassian.jira.plugin.devstatus.summary.beans.BuildOverallBean;
import com.atlassian.jira.plugin.devstatus.summary.data.SummaryJsonDataItemWithSource;
import com.atlassian.jira.plugin.devstatus.summary.util.AggregatorUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import javax.inject.Named;

@Named
public class BuildAggregator
implements Aggregator,
AggregatorHelper.JsonAggregator<BuildsObject> {
    @Override
    public String getType() {
        return BuildsObject.ID.getId();
    }

    @Override
    public SummaryItemBean aggregate(Collection<SummaryJsonDataItemWithSource> summaryData, long issueId) {
        return AggregatorHelper.create(this).aggregate(summaryData);
    }

    @Override
    public BuildsObject convertJsonNode(SummaryObjectMap summaryObject) {
        return summaryObject.as(BuildsObject.class);
    }

    public BuildOverallBean aggregateDataObjects(Collection<BuildsObject> builds) {
        ImmutableList allBuilds = ImmutableList.copyOf((Iterable)Iterables.filter(builds, (Predicate)Predicates.notNull()));
        Option<Date> lastUpdated = AggregatorUtils.maxDate(allBuilds, SummaryObject.TO_LAST_UPDATED);
        int failedBuildCount = Iterables.size((Iterable)Iterables.filter((Iterable)allBuilds, BuildsObject.isFailed));
        int successfulBuildCount = Iterables.size((Iterable)Iterables.filter((Iterable)allBuilds, BuildsObject.isSuccessful));
        int unknownBuildCount = Iterables.size((Iterable)Iterables.filter((Iterable)allBuilds, BuildsObject.isUnknown));
        return new BuildOverallBean(allBuilds.size(), (Date)lastUpdated.getOrNull(), failedBuildCount, successfulBuildCount, unknownBuildCount);
    }
}

