/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.rest;

import com.atlassian.jira.plugin.devstatus.api.DevStatusAuthenticationService;
import com.atlassian.jira.plugin.devstatus.labs.PhaseTwoFeatureFlag;
import com.atlassian.jira.plugin.devstatus.rest.RestUtils;
import com.atlassian.jira.plugin.devstatus.util.EqualableBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="/provider")
@Produces(value={"application/json"})
@AnonymousAllowed
public class DevStatusProviderResource {
    private final DevStatusAuthenticationService devStatusAuthenticationService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PhaseTwoFeatureFlag phaseTwoFeatureFlag;

    public DevStatusProviderResource(DevStatusAuthenticationService devStatusAuthenticationService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, PhaseTwoFeatureFlag phaseTwoFeatureFlag) {
        this.devStatusAuthenticationService = devStatusAuthenticationService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.phaseTwoFeatureFlag = phaseTwoFeatureFlag;
    }

    @GET
    @Path(value="/auth-status")
    public Response getAuthenticationStatus(@QueryParam(value="applicationType") List<String> applicationTypes) {
        if (!this.phaseTwoFeatureFlag.isPhaseTwoEnabled()) {
            return PhaseTwoFeatureFlag.restResponse();
        }
        this.validateApplicationTypes(applicationTypes);
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        Collection<DevStatusAuthenticationService.SourceWithAuthenticationStatus> authStatus = RestUtils.validateServiceOutcome(this.devStatusAuthenticationService.getAuthenticationStatus((Set<String>)ImmutableSet.copyOf(applicationTypes), user));
        return Response.ok((Object)new AuthenticationStatusBean(authStatus)).build();
    }

    private void validateApplicationTypes(List<String> applicationTypes) {
        if (CollectionUtils.isEmpty(applicationTypes)) {
            throw new RESTException(ErrorCollection.of((String[])new String[]{this.jiraAuthenticationContext.getI18nHelper().getText("devstatus.authentication.error.application-types.not-provided")}).reason(ErrorCollection.Reason.VALIDATION_FAILED));
        }
        for (String applicationType : applicationTypes) {
            if (!StringUtils.isEmpty((CharSequence)applicationType)) continue;
            throw new RESTException(ErrorCollection.of((String[])new String[]{this.jiraAuthenticationContext.getI18nHelper().getText("devstatus.authentication.error.application-types.empty")}).reason(ErrorCollection.Reason.VALIDATION_FAILED));
        }
    }

    public static class AuthenticationStatusBean
    extends EqualableBean {
        @JsonProperty
        private Collection<DevStatusAuthenticationService.SourceWithAuthenticationStatus> data;

        public AuthenticationStatusBean(Collection<DevStatusAuthenticationService.SourceWithAuthenticationStatus> data) {
            this.data = data;
        }

        public Collection<DevStatusAuthenticationService.SourceWithAuthenticationStatus> getData() {
            return this.data;
        }
    }
}

