/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugin.devstatus.api.DevStatusCtaService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSummaryService;
import com.atlassian.jira.plugin.devstatus.api.RemoteApp;
import com.atlassian.jira.plugin.devstatus.api.RemoteApps;
import com.atlassian.jira.plugin.devstatus.labs.PhaseTwoFeatureFlag;
import com.atlassian.jira.plugin.devstatus.rest.DetailBean;
import com.atlassian.jira.plugin.devstatus.rest.RestUtils;
import com.atlassian.jira.plugin.devstatus.rest.SummaryBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.math.NumberUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Path(value="/issue")
@Produces(value={"application/json"})
@AnonymousAllowed
public class DevStatusIssueResource {
    private final DevStatusCtaService devStatusCtaService;
    private final DevStatusSummaryService devStatusSummaryService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper i18nHelper;
    private final PhaseTwoFeatureFlag phaseTwoFeatureFlag;

    public DevStatusIssueResource(DevStatusCtaService devStatusCtaService, DevStatusSummaryService devStatusSummaryService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport I18nHelper i18nHelper, PhaseTwoFeatureFlag phaseTwoFeatureFlag) {
        this.devStatusCtaService = devStatusCtaService;
        this.devStatusSummaryService = devStatusSummaryService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.i18nHelper = i18nHelper;
        this.phaseTwoFeatureFlag = phaseTwoFeatureFlag;
    }

    @GET
    @Path(value="/targets")
    public Response getTargetsForCallToAction(@QueryParam(value="cta") String callToAction, @QueryParam(value="issueId") String issueIdStr) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        long issueId = this.checkIssueId(issueIdStr);
        RemoteApps remoteApps = RestUtils.validateServiceOutcome(this.devStatusCtaService.getRemoteApps(callToAction, issueId, user));
        return Response.ok((Object)new RestRemoteApps(remoteApps)).build();
    }

    @GET
    @Path(value="/summary")
    public Response getSummaryData(@QueryParam(value="issueId") String issueIdStr) {
        return this.getIssueData(issueIdStr, new Function<Long, ServiceOutcome<SummaryBean>>(){

            public ServiceOutcome<SummaryBean> apply(Long issueId) {
                return DevStatusIssueResource.this.devStatusSummaryService.getSummaryData(issueId, DevStatusIssueResource.this.jiraAuthenticationContext.getUser());
            }
        });
    }

    @GET
    @Path(value="/detail")
    public Response getDetailData(@QueryParam(value="issueId") String issueIdStr, final @QueryParam(value="applicationType") String applicationType, final @QueryParam(value="dataType") String dataType) {
        return this.getIssueData(issueIdStr, new Function<Long, ServiceOutcome<DetailBean>>(){

            public ServiceOutcome<DetailBean> apply(Long issueId) {
                return DevStatusIssueResource.this.devStatusSummaryService.getDetailData(issueId, applicationType, dataType, DevStatusIssueResource.this.jiraAuthenticationContext.getUser());
            }
        });
    }

    private <T> Response getIssueData(String issueIdStr, Function<Long, ServiceOutcome<T>> callback) {
        if (!this.phaseTwoFeatureFlag.isPhaseTwoEnabled()) {
            return PhaseTwoFeatureFlag.restResponse();
        }
        long issueId = this.checkIssueId(issueIdStr);
        return Response.ok(RestUtils.validateServiceOutcome((ServiceOutcome)callback.apply((Object)issueId))).build();
    }

    private long checkIssueId(String issueIdStr) {
        long issueId = NumberUtils.toLong((String)issueIdStr, (long)-1L);
        if (issueId == -1L) {
            throw new RESTException(ErrorCollection.of((String[])new String[]{this.i18nHelper.getText("devstatus.cta.error.invalid.issueId", issueIdStr)}).reason(ErrorCollection.Reason.VALIDATION_FAILED));
        }
        return issueId;
    }

    @JsonSerialize
    public static class RestRemoteApp {
        @JsonProperty
        private String name;
        @JsonProperty
        private String url;
        @JsonProperty
        private String baseUrl;
        @JsonProperty
        private String iconUrl;
        @JsonProperty
        private String iconClass;
        @JsonProperty
        private String applicationType;

        public RestRemoteApp() {
        }

        public RestRemoteApp(RemoteApp remoteApp) {
            this.name = remoteApp.getName();
            this.url = remoteApp.getUrl();
            this.baseUrl = remoteApp.getBaseUrl();
            this.iconUrl = remoteApp.getIconUrl();
            this.iconClass = remoteApp.getIconClass();
            this.applicationType = remoteApp.getApplicationType();
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public String getApplicationType() {
            return this.applicationType;
        }
    }

    @JsonSerialize
    public static class RestRemoteApps {
        @JsonProperty
        private String prompt;
        @JsonProperty
        private List<RestRemoteApp> remoteApps;

        public RestRemoteApps() {
        }

        public RestRemoteApps(RemoteApps remoteApps) {
            this.prompt = remoteApps.getPrompt();
            this.remoteApps = Lists.transform(remoteApps.getRemoteApps(), (Function)new Function<RemoteApp, RestRemoteApp>(){

                public RestRemoteApp apply(RemoteApp remoteApp) {
                    return new RestRemoteApp(remoteApp);
                }
            });
        }

        public String getPrompt() {
            return this.prompt;
        }

        public List<RestRemoteApp> getRemoteApps() {
            return this.remoteApps;
        }
    }
}

