/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.fugue.Pair;
import com.atlassian.fusion.schema.common.PullRequestState;
import com.atlassian.fusion.schema.detail.BaseRepository;
import com.atlassian.fusion.schema.detail.User;
import com.atlassian.fusion.schema.detail.branch.Branch;
import com.atlassian.fusion.schema.detail.branch.Branches;
import com.atlassian.fusion.schema.detail.branch.PullRequest;
import com.atlassian.fusion.schema.detail.branch.PullRequestRef;
import com.atlassian.fusion.schema.detail.branch.Reviewer;
import com.atlassian.fusion.schema.util.EnumUtils;
import com.atlassian.guava.collect.Ordering;
import com.atlassian.guava.collect.Sets;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsBranchServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsPullRequestServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsRepositoryServiceAccessor;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsApplicationTypeInfo;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.PullRequestRef;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsBranchService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsPullRequestService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsRepositoryService;
import com.atlassian.jira.util.UrlBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DvcsPullRequestDetailHelper {
    final DvcsBranchServiceAccessor dvcsBranchServiceAccessor;
    final DvcsPullRequestServiceAccessor dvcsPullRequestServicAccessor;
    final DvcsRepositoryServiceAccessor dvcsRepositoryServiceAccessor;

    public DvcsPullRequestDetailHelper(DvcsBranchServiceAccessor dvcsBranchServiceAccessor, DvcsPullRequestServiceAccessor dvcsPullRequestServiceAccessor, DvcsRepositoryServiceAccessor dvcsRepositoryServiceAccessor) {
        this.dvcsBranchServiceAccessor = dvcsBranchServiceAccessor;
        this.dvcsPullRequestServicAccessor = dvcsPullRequestServiceAccessor;
        this.dvcsRepositoryServiceAccessor = dvcsRepositoryServiceAccessor;
    }

    public Branches getPullRequestInfoMappedByRepository(Set<String> issueKeys, DvcsApplicationTypeInfo dvcsApplicationTypeInfo) {
        DvcsBranchService branchService = (DvcsBranchService)this.dvcsBranchServiceAccessor.getService();
        DvcsRepositoryService repoService = (DvcsRepositoryService)this.dvcsRepositoryServiceAccessor.getService();
        Collection<com.atlassian.jira.plugins.dvcs.model.Branch> branches = this.getBranchesFromIssueKeys(issueKeys, dvcsApplicationTypeInfo, branchService);
        Collection<com.atlassian.jira.plugins.dvcs.model.PullRequest> pullrequests = this.getPullRequestsForIssueKeys(issueKeys, dvcsApplicationTypeInfo);
        Collection<Branch> extraBranches = this.getExtraBranches(repoService, dvcsApplicationTypeInfo, branches, pullrequests);
        Ordering<PullRequest> prOrder = Ordering.natural().onResultOf(new com.atlassian.guava.base.Function<PullRequest, Comparable>(){

            @Override
            public Comparable apply(PullRequest input) {
                return input.getId();
            }
        });
        Ordering<Branch> brOrder = Ordering.natural().onResultOf(new com.atlassian.guava.base.Function<Branch, Comparable>(){

            @Override
            @Nullable
            public Comparable apply(@Nullable Branch input) {
                return input.getName();
            }
        });
        List<PullRequest> jsonPullRequests = prOrder.sortedCopy(Collections2.transform(pullrequests, DvcsPullRequestDetailHelper.toPullRequests(repoService, dvcsApplicationTypeInfo)));
        List<Branch> jsonBranches = brOrder.sortedCopy(CollectionUtils.union((Collection)Collections2.transform(branches, DvcsPullRequestDetailHelper.toBranch(repoService, dvcsApplicationTypeInfo)), extraBranches));
        return new Branches.Builder().addPullRequests(jsonPullRequests).addBranches(jsonBranches).build();
    }

    private Collection<Branch> getExtraBranches(DvcsRepositoryService repoService, DvcsApplicationTypeInfo dvcsApplicationTypeInfo, Collection<com.atlassian.jira.plugins.dvcs.model.Branch> branches, Collection<com.atlassian.jira.plugins.dvcs.model.PullRequest> pullrequests) {
        HashSet branchNames = Sets.newHashSet(Collections2.transform(branches, DvcsPullRequestDetailHelper.toBranchComparer()));
        HashSet prBranchNames = Sets.newHashSet(Collections2.transform(pullrequests, DvcsPullRequestDetailHelper.toSourceBranchComparer()));
        Sets.SetView<Pair> difference = Sets.difference(prBranchNames, branchNames);
        ArrayList retVal = Lists.newArrayList();
        for (Pair itemPair : difference) {
            String branchName = (String)itemPair.right();
            Integer repoId = (Integer)itemPair.left();
            Repository repo = repoService.getRepository(repoId.intValue());
            Branch b = ((Branch.Builder)new Branch.Builder(branchName, DvcsPullRequestDetailHelper.getBranchUrl(dvcsApplicationTypeInfo, repo.getRepositoryUrl(), branchName)).repository((BaseRepository)DvcsPullRequestDetailHelper.toBaseRepository().apply((Object)repo)).createPullRequestUrl(dvcsApplicationTypeInfo.getCreatePullRequestUrl(repo, branchName))).build();
            retVal.add(b);
        }
        return retVal;
    }

    private static Function<com.atlassian.jira.plugins.dvcs.model.PullRequest, Pair<Integer, String>> toSourceBranchComparer() {
        return new Function<com.atlassian.jira.plugins.dvcs.model.PullRequest, Pair<Integer, String>>(){

            public Pair<Integer, String> apply(com.atlassian.jira.plugins.dvcs.model.PullRequest input) {
                return new Pair((Object)input.getRepositoryId(), (Object)input.getSource().getBranch());
            }
        };
    }

    private static Function<com.atlassian.jira.plugins.dvcs.model.Branch, Pair<Integer, String>> toBranchComparer() {
        return new Function<com.atlassian.jira.plugins.dvcs.model.Branch, Pair<Integer, String>>(){

            public Pair<Integer, String> apply(com.atlassian.jira.plugins.dvcs.model.Branch input) {
                return new Pair((Object)input.getRepositoryId(), (Object)input.getName());
            }
        };
    }

    private static Function<Repository, BaseRepository> toBaseRepository() {
        return new Function<Repository, BaseRepository>(){

            public BaseRepository apply(Repository input) {
                return ((BaseRepository.Builder)((BaseRepository.Builder)new BaseRepository.Builder(input.getName()).avatar(input.getLogo())).url(input.getRepositoryUrl())).build();
            }
        };
    }

    private static Function<com.atlassian.jira.plugins.dvcs.model.Branch, Branch> toBranch(final DvcsRepositoryService repoService, final DvcsApplicationTypeInfo dvcsApplicationTypeInfo) {
        return new Function<com.atlassian.jira.plugins.dvcs.model.Branch, Branch>(){

            public Branch apply(com.atlassian.jira.plugins.dvcs.model.Branch branch) {
                Repository repository = repoService.getRepository(branch.getRepositoryId());
                return ((Branch.Builder)new Branch.Builder(branch.getName(), DvcsPullRequestDetailHelper.getBranchUrl(dvcsApplicationTypeInfo, repository.getRepositoryUrl(), branch.getName())).repository((BaseRepository)DvcsPullRequestDetailHelper.toBaseRepository().apply((Object)repository)).createPullRequestUrl(dvcsApplicationTypeInfo.getCreatePullRequestUrl(repository, branch.getName()))).build();
            }
        };
    }

    private static Function<com.atlassian.jira.plugins.dvcs.model.PullRequest, PullRequest> toPullRequests(final DvcsRepositoryService repoService, final DvcsApplicationTypeInfo dvcsApplicationTypeInfo) {
        return new Function<com.atlassian.jira.plugins.dvcs.model.PullRequest, PullRequest>(){

            public PullRequest apply(com.atlassian.jira.plugins.dvcs.model.PullRequest pullRequest) {
                Repository repository = repoService.getRepository(pullRequest.getRepositoryId());
                List reviewers = DvcsPullRequestDetailHelper.getReviewers(repoService, pullRequest.getParticipants(), repository);
                DvcsUser authorUser = repoService.getDvcsUser(repository, pullRequest.getAuthor(), pullRequest.getAuthor());
                return new PullRequest.Builder("#" + pullRequest.getRemoteId(), pullRequest.getName()).author(((User.Builder)new User.Builder((String)StringUtils.defaultIfBlank((CharSequence)authorUser.getFullName(), (CharSequence)authorUser.getUsername())).avatar(authorUser.getAvatar())).build()).commentCount(pullRequest.getCommentCount()).destination(DvcsPullRequestDetailHelper.createRef(dvcsApplicationTypeInfo, pullRequest.getDestination())).lastUpdate(pullRequest.getUpdatedOn()).addReviewers(reviewers).source(DvcsPullRequestDetailHelper.createRef(dvcsApplicationTypeInfo, pullRequest.getSource())).status(EnumUtils.valueOf(PullRequestState.class, pullRequest.getStatus(), PullRequestState.UNKNOWN)).url(pullRequest.getUrl()).build();
            }
        };
    }

    private static List<Reviewer> getReviewers(final DvcsRepositoryService repoService, List<Participant> participants, final Repository repository) {
        return ImmutableList.copyOf((Collection)Lists.transform(participants, (Function)new Function<Participant, Reviewer>(){

            public Reviewer apply(Participant reviewer) {
                DvcsUser reviewerUser = repoService.getDvcsUser(repository, reviewer.getUsername(), reviewer.getUsername());
                return ((Reviewer.Builder)new Reviewer.Builder((String)StringUtils.defaultIfBlank((CharSequence)reviewerUser.getFullName(), (CharSequence)reviewerUser.getUsername())).avatar(reviewerUser.getAvatar())).approved(reviewer.isApproved()).build();
            }
        }));
    }

    private Collection<com.atlassian.jira.plugins.dvcs.model.PullRequest> getPullRequestsForIssueKeys(Set<String> issueKeys, DvcsApplicationTypeInfo dvcsApplicationTypeInfo) {
        DvcsPullRequestService pullRequestService = (DvcsPullRequestService)this.dvcsPullRequestServicAccessor.getService();
        return pullRequestService.getPullRequests(issueKeys, dvcsApplicationTypeInfo.getType().getType());
    }

    private Collection<com.atlassian.jira.plugins.dvcs.model.Branch> getBranchesFromIssueKeys(Set<String> issueKeys, DvcsApplicationTypeInfo dvcsApplicationTypeInfo, DvcsBranchService branchService) {
        return branchService.getBranches(issueKeys, dvcsApplicationTypeInfo.getType().getType());
    }

    private static com.atlassian.fusion.schema.detail.branch.PullRequestRef createRef(DvcsApplicationTypeInfo dvcsApplicationTypeInfo, PullRequestRef destination) {
        return new PullRequestRef.Builder(destination.getBranch(), DvcsPullRequestDetailHelper.getBranchUrl(dvcsApplicationTypeInfo, destination)).build();
    }

    private static String getBranchUrl(DvcsApplicationTypeInfo dvcsApplicationTypeInfo, PullRequestRef branch) {
        return DvcsPullRequestDetailHelper.getBranchUrl(dvcsApplicationTypeInfo, branch.getRepositoryUrl(), branch.getBranch());
    }

    private static String getBranchUrl(DvcsApplicationTypeInfo dvcsApplicationTypeInfo, String repoUrl, String name) {
        return repoUrl == null ? null : new UrlBuilder(repoUrl).addPath(dvcsApplicationTypeInfo.getBranchPath()).addPath(name).asUrlString();
    }
}

