/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.plugin.devstatus.util.SecurityHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class TrustedAppsHelper {
    private final SecurityHelper securityHelper;
    private final UserManager userManager;
    private static final String SYS_ADMIN_USERNAME = "sysadmin";

    @Inject
    public TrustedAppsHelper(SecurityHelper securityHelper, @ComponentImport UserManager userManager) {
        this.securityHelper = securityHelper;
        this.userManager = userManager;
    }

    @Nullable
    public ApplicationLinkRequestFactory createRequestFactoryWithImpersonation(final ApplicationLink applicationLink) {
        ApplicationUser sysAdminUser;
        if (this.isOnDemand() && (sysAdminUser = this.getSysAdminUser()) != null) {
            ApplicationLinkRequestFactory trustedAppsRequestFactory = this.securityHelper.doAsUser("create trusted apps request factory", sysAdminUser, new SecurityHelper.UncheckedOperation<ApplicationLinkRequestFactory>(){

                @Override
                public ApplicationLinkRequestFactory perform() {
                    return applicationLink.createAuthenticatedRequestFactory(TrustedAppsAuthenticationProvider.class);
                }
            });
            return new ImpersonatingApplicationLinkRequestFactory(trustedAppsRequestFactory, sysAdminUser);
        }
        return null;
    }

    @Nullable
    public ApplicationLinkRequestFactory createRequestFactory(ApplicationLink applicationLink) {
        if (this.isOnDemand()) {
            return applicationLink.createAuthenticatedRequestFactory(TrustedAppsAuthenticationProvider.class);
        }
        return null;
    }

    private boolean isOnDemand() {
        return CoreFeatures.ON_DEMAND.isSystemPropertyEnabled();
    }

    @VisibleForTesting
    ApplicationUser getSysAdminUser() {
        return this.userManager.getUserByName(SYS_ADMIN_USERNAME);
    }

    @VisibleForTesting
    class ImpersonatingApplicationLinkRequestFactory
    implements ApplicationLinkRequestFactory {
        @VisibleForTesting
        final ApplicationLinkRequestFactory delegate;
        @VisibleForTesting
        final ApplicationUser impersonatingUser;

        private ImpersonatingApplicationLinkRequestFactory(ApplicationLinkRequestFactory delegate, ApplicationUser impersonatingUser) {
            this.delegate = delegate;
            this.impersonatingUser = impersonatingUser;
        }

        public ApplicationLinkRequest createRequest(final Request.MethodType methodType, final String url) throws CredentialsRequiredException {
            return TrustedAppsHelper.this.securityHelper.doAsUser("create trusted apps request", this.impersonatingUser, new SecurityHelper.Operation<ApplicationLinkRequest, CredentialsRequiredException>(){

                @Override
                public ApplicationLinkRequest perform() throws CredentialsRequiredException {
                    return ImpersonatingApplicationLinkRequestFactory.this.delegate.createRequest(methodType, url);
                }
            });
        }

        public URI getAuthorisationURI(URI callback) {
            return this.delegate.getAuthorisationURI(callback);
        }

        public URI getAuthorisationURI() {
            return this.delegate.getAuthorisationURI();
        }
    }
}

