/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.guava.cache.Cache;
import com.atlassian.guava.cache.CacheBuilder;
import com.atlassian.guava.util.concurrent.RateLimiter;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ApplicationLinkRateLimiter {
    private static final String PERMITS_PER_SECOND = "jira.devstatus.applink.ratelimit";
    private static final int PERMITS_PER_SECOND_DEFAULT = 20;
    private final int permitsPerSecond;
    private final EventPublisher eventPublisher;
    private final Cache<ApplicationId, RateLimiter> limiterCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final AppLinkEventListener appLinkEventListener = new AppLinkEventListener();

    @Inject
    public ApplicationLinkRateLimiter(EventPublisher eventPublisher) {
        this(Integer.getInteger(PERMITS_PER_SECOND, 20), eventPublisher);
    }

    @VisibleForTesting
    public ApplicationLinkRateLimiter(int permitsPerSecond, EventPublisher eventPublisher) {
        this.permitsPerSecond = permitsPerSecond;
        this.eventPublisher = eventPublisher;
    }

    public boolean tryAcquire(ApplicationLink applicationLink) {
        return this.getRateLimiter(applicationLink).tryAcquire();
    }

    public int getRate(ApplicationLink applicationLink) {
        return this.permitsPerSecond;
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this.appLinkEventListener);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this.appLinkEventListener);
    }

    private RateLimiter getRateLimiter(final ApplicationLink applicationLink) {
        try {
            return this.limiterCache.get(applicationLink.getId(), new Callable<RateLimiter>(){

                @Override
                public RateLimiter call() throws Exception {
                    return RateLimiter.create(ApplicationLinkRateLimiter.this.getRate(applicationLink));
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error creating RateLimiter for " + applicationLink, e);
        }
    }

    public class AppLinkEventListener {
        @EventListener
        public void onIdModified(ApplicationLinksIDChangedEvent event) {
            ApplicationLinkRateLimiter.this.limiterCache.invalidate(event.getOldApplicationId());
        }

        @EventListener
        public void onDeleted(ApplicationLinkDeletedEvent event) {
            ApplicationLinkRateLimiter.this.limiterCache.invalidate(event.getApplicationId());
        }
    }
}

