/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.labs;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.devstatus.impl.NavigationKeys;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;

@Named
public class PhaseTwoFeatureFlag {
    @VisibleForTesting
    static final String PHASE_TWO_ENABLED = "jira.plugin.devstatus.phasetwo.enabled";
    private final FeatureManager featureManager;
    private static final Set<String> PHASE_TWO_CALL_TO_ACTIONS = ImmutableSet.of((Object)NavigationKeys.CTA_CREATE_REVIEW);

    @Inject
    public PhaseTwoFeatureFlag(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public boolean isPhaseTwoEnabled() {
        return this.featureManager.isEnabled(PHASE_TWO_ENABLED);
    }

    public boolean isPhaseTwoCallToAction(String cta) {
        return PHASE_TWO_CALL_TO_ACTIONS.contains(cta);
    }

    public static Response restResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

