/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.fugue.Option;
import com.atlassian.guava.cache.Cache;
import com.atlassian.guava.cache.CacheBuilder;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationLinkService;
import com.atlassian.jira.plugin.devstatus.impl.RequestTimeoutHelper;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultDevStatusSupportedApplicationLinkService
implements DevStatusSupportedApplicationLinkService {
    private static final Function<LinkedAppWithCapabilities, String> TO_APP_ID = new Function<LinkedAppWithCapabilities, String>(){

        public String apply(LinkedAppWithCapabilities input) {
            return input.getApplicationLinkId();
        }
    };
    private final Cache<ApplicationId, Boolean> appLinks2LOSupportCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final ApplicationLinkService applicationLinkService;
    private final LinkedApplicationCapabilities capabilities;
    private final DataProviderHelper dataProviderHelper;
    private final RequestTimeoutHelper requestTimeoutHelper;

    @Inject
    public DefaultDevStatusSupportedApplicationLinkService(LinkedApplicationCapabilities capabilities, @ComponentImport ApplicationLinkService applicationLinkService, DataProviderHelper dataProviderHelper, RequestTimeoutHelper requestTimeoutHelper) {
        this.applicationLinkService = applicationLinkService;
        this.capabilities = capabilities;
        this.dataProviderHelper = dataProviderHelper;
        this.requestTimeoutHelper = requestTimeoutHelper;
    }

    private boolean isAppLink2LOCompatible(final ApplicationLink applicationLink) {
        if (applicationLink == null) {
            return false;
        }
        try {
            return this.appLinks2LOSupportCache.get(applicationLink.getId(), new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Option<DataProvider> dataProvider = DefaultDevStatusSupportedApplicationLinkService.this.dataProviderHelper.getFromId(applicationLink.getId().get());
                    if (!dataProvider.isDefined()) {
                        return false;
                    }
                    IssueDataRequest dummyIssueDataRequest = new IssueDataRequest(1000L, (Iterable<String>)ImmutableSet.of((Object)"RAND-1"), true);
                    Promise<DataProviderResponse> summaryPromise = ((DataProvider)dataProvider.get()).getSummaryDataFutureFor(dummyIssueDataRequest);
                    try {
                        return ((DataProviderResponse)summaryPromise.get(DefaultDevStatusSupportedApplicationLinkService.this.requestTimeoutHelper.getSummaryTimeOut(), TimeUnit.MILLISECONDS)).isSuccessful();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Override
    public boolean recheckAppLink2LOSupport(@Nonnull ApplicationLink applicationLink) {
        this.appLinks2LOSupportCache.invalidate(applicationLink.getId());
        return this.isAppLink2LOCompatible(applicationLink);
    }

    @Override
    public boolean hasApplicationTypeFull2LOSupport(@Nonnull Class<? extends ApplicationType> applicationType) {
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks(applicationType);
        boolean allSupport2LO = true;
        for (ApplicationLink applicationLink : applicationLinks) {
            if (this.hasApplicationLink2LOSupport(applicationLink)) continue;
            allSupport2LO = false;
        }
        return allSupport2LO;
    }

    @Override
    public boolean hasApplicationLink2LOSupport(@Nonnull ApplicationLink applicationLink) {
        return this.isAppLink2LOCompatible(applicationLink);
    }

    @Override
    public boolean hasApplicationTypeFullDevStatusCompatibility(Class<? extends ApplicationType> applicationType) {
        ImmutableSet capableAppIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.capabilities.capableOf("dev-status-summary"), TO_APP_ID));
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks(applicationType);
        for (ApplicationLink appLink : applicationLinks) {
            if (capableAppIds.contains(appLink.getId().toString()) && this.hasApplicationLink2LOSupport(appLink)) continue;
            return false;
        }
        return true;
    }
}

