/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.impl;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.plugin.devstatus.api.DevStatusAuthenticationService;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@ExportAsService
@Named
public class DefaultDevStatusAuthenticationService
implements DevStatusAuthenticationService {
    private final DataProviderHelper dataProviderHelper;

    @Inject
    public DefaultDevStatusAuthenticationService(DataProviderHelper dataProviderHelper) {
        this.dataProviderHelper = dataProviderHelper;
    }

    @Override
    public ServiceOutcome<Collection<DevStatusAuthenticationService.SourceWithAuthenticationStatus>> getAuthenticationStatus(final Set<String> types, @Nonnull ApplicationUser user) {
        Collection matchingDataProviders = Collections2.filter(this.dataProviderHelper.getDataProviders(), (Predicate)new Predicate<DataProvider>(){

            public boolean apply(DataProvider input) {
                return types.contains(input.getSource().getType());
            }
        });
        return ServiceOutcomeImpl.ok((Object)Collections2.transform((Collection)matchingDataProviders, (Function)new Function<DataProvider, DevStatusAuthenticationService.SourceWithAuthenticationStatus>(){

            public DevStatusAuthenticationService.SourceWithAuthenticationStatus apply(DataProvider dataProvider) {
                return new DevStatusAuthenticationService.SourceWithAuthenticationStatus(dataProvider.getSource(), dataProvider.isAuthenticated(), dataProvider.isConfigured());
            }
        }));
    }
}

