/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.summary;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.summary.SummaryTarget;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class Summary
extends Json {
    @JsonProperty
    private Map<String, List<SummaryTarget>> targets = ImmutableMap.of();

    private Summary() {
    }

    private Summary(Builder builder) {
        this.targets = Collections.unmodifiableMap(builder.targets);
    }

    public Map<String, List<SummaryTarget>> getTargets() {
        return this.targets;
    }

    public static class Builder {
        private Map<String, List<SummaryTarget>> targets = Maps.newHashMap();

        public Builder add(String target, Iterable<? extends SummaryTarget> values) {
            List<SummaryTarget> oldValues = this.targets.get(target);
            this.targets.put(target, (List<SummaryTarget>)ImmutableList.copyOf(oldValues != null ? Iterables.concat(oldValues, values) : values));
            return this;
        }

        public Builder add(String target, SummaryTarget value) {
            return this.add(target, (Iterable<? extends SummaryTarget>)ImmutableList.of((Object)value));
        }

        public Summary build() {
            return new Summary(this);
        }
    }
}

