/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.review;

import com.atlassian.fusion.schema.detail.User;
import com.atlassian.fusion.schema.detail.review.ReviewOverview;
import com.atlassian.fusion.schema.detail.review.Reviewer;
import com.atlassian.fusion.schema.util.DateUtils;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class Review
extends ReviewOverview {
    @JsonProperty
    private String dueDate;
    @JsonProperty
    private String lastModified;
    @JsonProperty
    private int commentCount;
    @JsonProperty
    private User author;
    @JsonProperty
    private User moderator;
    @JsonProperty
    private List<Reviewer> reviewers;

    private Review() {
    }

    @JsonIgnore
    @Nullable
    public Date getDueDate() {
        return DateUtils.parse(this.dueDate);
    }

    @JsonIgnore
    @Nullable
    public Date getLastModified() {
        return DateUtils.parse(this.lastModified);
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    @Nullable
    public User getAuthor() {
        return this.author;
    }

    @Nullable
    public User getModerator() {
        return this.moderator;
    }

    @Nonnull
    public List<Reviewer> getReviewers() {
        return Review.nonNullList(this.reviewers);
    }

    private Review(Builder builder) {
        super(builder);
        this.dueDate = builder.dueDate;
        this.lastModified = builder.lastModified;
        this.commentCount = builder.commentCount;
        this.author = builder.author;
        this.moderator = builder.moderator;
        this.reviewers = builder.reviewers.build();
    }

    public static class Builder
    extends ReviewOverview.Builder<Builder> {
        private String dueDate;
        private String lastModified;
        private int commentCount;
        private User author;
        private User moderator;
        private ImmutableList.Builder<Reviewer> reviewers = ImmutableList.builder();

        public Builder(String id, String url) {
            super(id, url);
        }

        public Builder dueDate(Date value) {
            this.dueDate = DateUtils.format(value);
            return this;
        }

        @Deprecated
        public Builder dueDate(String value) {
            this.dueDate = value;
            return this;
        }

        public Builder lastModified(Date value) {
            this.lastModified = DateUtils.format(value);
            return this;
        }

        @Deprecated
        public Builder lastModified(String value) {
            this.lastModified = value;
            return this;
        }

        public Builder commentCount(int value) {
            this.commentCount = value;
            return this;
        }

        public Builder author(User value) {
            this.author = value;
            return this;
        }

        public Builder moderator(User value) {
            this.moderator = value;
            return this;
        }

        public Builder addReviewer(Reviewer ... value) {
            this.reviewers.add((Object[])value);
            return this;
        }

        public Builder addReviewers(Iterable<Reviewer> value) {
            this.reviewers.addAll(value);
            return this;
        }

        @Override
        public Review build() {
            return new Review(this);
        }
    }
}

