/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.branch;

import com.atlassian.fusion.schema.detail.branch.BaseBranch;
import com.atlassian.fusion.schema.detail.branch.PullRequest;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class RepositoryBranch
extends BaseBranch {
    @JsonProperty
    private List<PullRequest> pullRequests;

    private RepositoryBranch() {
    }

    private RepositoryBranch(Builder builder) {
        super(builder);
        this.pullRequests = builder.pullRequests.build();
    }

    public List<PullRequest> getPullRequests() {
        return RepositoryBranch.nonNullList(this.pullRequests);
    }

    public static class Builder
    extends BaseBranch.Builder<Builder> {
        public static Function<Builder, RepositoryBranch> BUILD = new Function<Builder, RepositoryBranch>(){

            public RepositoryBranch apply(Builder builder) {
                return builder.build();
            }
        };
        private final ImmutableList.Builder<PullRequest> pullRequests = ImmutableList.builder();

        public Builder(String name, String url) {
            super(name, url);
        }

        public Builder addPullRequest(PullRequest pullRequest) {
            this.pullRequests.add((Object)pullRequest);
            return this;
        }

        public Builder addPullRequests(PullRequest ... values) {
            return this.addPullRequests((Iterable<PullRequest>)ImmutableList.copyOf((Object[])values));
        }

        public Builder addPullRequests(Iterable<PullRequest> values) {
            this.pullRequests.addAll(values);
            return this;
        }

        @Override
        public RepositoryBranch build() {
            return new RepositoryBranch(this);
        }
    }
}

