/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fusion.schema.detail.branch;

import com.atlassian.fusion.schema.Json;
import com.atlassian.fusion.schema.detail.branch.Branch;
import com.atlassian.fusion.schema.detail.branch.PullRequest;
import com.atlassian.fusion.schema.detail.branch.Repository;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonProperty;

public class Branches
extends Json {
    @JsonProperty
    private List<Branch> branches;
    @JsonProperty
    private List<PullRequest> pullRequests;
    @JsonProperty
    private List<Repository> repositories;

    private Branches() {
    }

    private Branches(Builder builder) {
        this.branches = builder.branches.build();
        this.pullRequests = builder.pullRequests.build();
        this.repositories = builder.repositories.build();
    }

    @Deprecated
    @Nonnull
    public List<Repository> getRepositories() {
        return Branches.nonNullList(this.repositories);
    }

    @Nonnull
    public List<PullRequest> getPullRequests() {
        return Branches.nonNullList(this.pullRequests);
    }

    @Nonnull
    public List<Branch> getBranches() {
        return Branches.nonNullList(this.branches);
    }

    public static class Builder {
        private ImmutableList.Builder<Branch> branches = ImmutableList.builder();
        private ImmutableList.Builder<PullRequest> pullRequests = ImmutableList.builder();
        private ImmutableList.Builder<Repository> repositories = ImmutableList.builder();

        public Builder addBranches(Iterable<Branch> values) {
            this.branches.addAll(values);
            return this;
        }

        public Builder addBranch(Branch branch) {
            this.branches.add((Object)branch);
            return this;
        }

        public Builder addPullRequest(PullRequest pullRequest) {
            this.pullRequests.add((Object)pullRequest);
            return this;
        }

        public Builder addPullRequests(Iterable<PullRequest> values) {
            this.pullRequests.addAll(values);
            return this;
        }

        @Deprecated
        public Builder addRepository(Repository repository) {
            this.repositories.add((Object)repository);
            return this;
        }

        public Builder addRepositories(Iterable<Repository> values) {
            this.repositories.addAll(values);
            return this;
        }

        public Branches build() {
            return new Branches(this);
        }
    }
}

