/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeMultiInspector;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ProjectPermissionMultiInspector
implements ProjectPermissionInspector {
    private PermissionSchemeManager permissionSchemeManager;
    private final String type;
    private SchemeMultiInspector inspector;

    public ProjectPermissionMultiInspector(@Nonnull PermissionSchemeManager permissionSchemeManager, @Nonnull String type, @Nonnull SchemeMultiInspector inspector) {
        Preconditions.checkNotNull((Object)type);
        this.permissionSchemeManager = permissionSchemeManager;
        this.type = type;
        this.inspector = inspector;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(@Nonnull PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            return Collections.emptyList();
        }
        if (context.permission() == null) {
            return Collections.emptyList();
        }
        ProjectPermissionKey permissionKey = context.permission().getProjectPermissionKey();
        Collection permissionSchemeEntries = this.permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, permissionKey);
        Iterable permissionSchemeEntities = permissionSchemeEntries.stream().filter(new Predicate<PermissionSchemeEntry>(){

            @Override
            public boolean test(PermissionSchemeEntry permissionSchemeEntry) {
                return ProjectPermissionMultiInspector.this.type.equals(permissionSchemeEntry.getType());
            }
        }).map(new Function<PermissionSchemeEntry, SchemeEntity>(){

            @Override
            public SchemeEntity apply(PermissionSchemeEntry permissionSchemeEntry) {
                return new SchemeEntity(permissionSchemeEntry.getType(), permissionSchemeEntry.getParameter(), (Object)permissionSchemeEntry.getPermissionKey());
            }
        }).collect(Collectors.toList());
        return this.inspector.inspect(permissionSchemeEntities, context);
    }
}

