/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeNoPermissionsInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;
    private final I18nResolver i18nResolver;

    @Autowired
    public PermissionSchemeNoPermissionsInspector(PermissionSchemeManager permissionSchemeManager, I18nResolver i18nResolver) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            return Collections.emptyList();
        }
        List entitiesForBrowse = permissionScheme.getEntitiesByType((Object)context.permission().getProjectPermissionKey());
        ArrayList notes = Lists.newArrayList();
        if (entitiesForBrowse.isEmpty()) {
            InspectionNote.Builder problemBuilder = InspectionNote.problem(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.nopermissions.summary")).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.nopermissions.details").addPlainParameter(this.i18nResolver.getText(context.permission().getNameI18nKey())).newI18nLinkParameter().pathKey("permissionhelper.inspection.link.addnewpermission").urlParams(permissionScheme.getId().toString(), context.permission().getKey()).textKey("permissionhelper.inspection.nopermissions.linktext").add().build());
            notes.add(problemBuilder.build());
        }
        return notes;
    }
}

