/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.IdentifiableInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ViewOperationValueInspector
extends AbstractFieldInspector<OrderableField>
implements FieldInspector<OrderableField>,
IdentifiableInspector {
    public static final String INSPECTION_ID = "com.atlassian.jira.customfieldhelper.inspection.VIEW_OPERATION_VALUE";

    public ViewOperationValueInspector() {
        super(OrderableField.class);
    }

    @Override
    @Nonnull
    public String inspectionId() {
        return INSPECTION_ID;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(OrderableField field, FieldInspectionContext context) {
        if (context.issueOperation() != IssueOperations.VIEW_ISSUE_OPERATION) {
            return Collections.emptyList();
        }
        if (field.hasValue(context.issue())) {
            return ImmutableList.of((Object)this.createOk(field, context));
        }
        return ImmutableList.of((Object)this.createProblem(field, context));
    }

    private InspectionNote createOk(OrderableField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context)).build();
    }

    private InspectionNote createProblem(OrderableField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails((Field)field, context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.value.summary").build();
    }

    private InspectionMessage createOkDetails(OrderableField field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.value.ok").addPlainParameter(field.getName()).build();
    }

    private InspectionMessage createProblemDetails(Field field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.value.problem").addPlainParameter(field.getName()).addPlainParameter(context.issue().getKey()).build();
    }
}

