/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public abstract class AbstractFieldInspector<F extends Field>
implements FieldInspector<F> {
    protected final Class<F> supportedType;

    protected AbstractFieldInspector(Class<F> supportedType) {
        this.supportedType = (Class)Preconditions.checkNotNull(supportedType, (Object)"supportedType");
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(@Nonnull FieldInspectionContext context) {
        if (!context.isOfType(this.supportedType())) {
            throw new IllegalStateException("Invoked inspect on context with unsupported type " + context.field().getClass().getName() + ", I only support " + this.supportedType().getName());
        }
        return this.inspect(context.asFieldType(this.supportedType()), context);
    }

    @Override
    public final Class<F> supportedType() {
        return this.supportedType;
    }
}

