/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.context;

import com.atlassian.jira.customfieldhelper.api.IdentifiableInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.Inspector;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public class DefaultInspectionContext
implements InspectionContext {
    final Issue issue;
    final IssueOperation issueOperation;
    final Project project;
    final IssueType issueType;
    private final String baseUrl;
    private final ApplicationUser user;
    private final I18nHelper i18nHelper;
    final List<String> excluded = Lists.newArrayList();
    boolean excludeAll = false;

    public DefaultInspectionContext(Issue issue, IssueOperation operation, Project project, IssueType issueType, String baseUrl, ApplicationUser user, I18nHelper i18nHelper) {
        this.user = user;
        this.issueOperation = operation;
        this.issueType = (IssueType)Preconditions.checkNotNull((Object)issueType, (Object)"issueType");
        this.issue = (Issue)Preconditions.checkNotNull((Object)issue, (Object)"issue");
        this.project = DefaultInspectionContext.getProject(project, issue);
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper, (Object)"i18nHelper");
    }

    private static Project getProject(Project project, Issue issue) {
        if (project != null) {
            return project;
        }
        return issue.getProjectObject();
    }

    @Override
    @Nonnull
    public ApplicationUser user() {
        return this.user;
    }

    @Override
    public boolean isAnonymous() {
        return this.user == null;
    }

    @Override
    @Nonnull
    public I18nHelper i18n() {
        return this.i18nHelper;
    }

    @Override
    @Nonnull
    public Issue issue() {
        return this.issue;
    }

    @Override
    public boolean issueExists() {
        return this.issue.isCreated();
    }

    @Override
    @Nonnull
    public IssueType issueType() {
        return this.issueType;
    }

    @Override
    @Nonnull
    public String issueTypeName() {
        return this.issueType.getNameTranslation(this.i18n());
    }

    @Override
    @Nonnull
    public Project project() {
        return this.project;
    }

    @Override
    @Nonnull
    public IssueOperation issueOperation() {
        return this.issueOperation;
    }

    @Override
    @Nonnull
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public void exclude(String inspectionId) {
        this.excluded.add(inspectionId);
    }

    @Override
    public void excludeAll() {
        this.excludeAll = true;
    }

    @Override
    public boolean isExcluded(Inspector<?> inspector) {
        return this.excludeAll || this.excludedById(inspector);
    }

    @Override
    public boolean isExcludeAll() {
        return this.excludeAll;
    }

    private boolean excludedById(Inspector<?> inspector) {
        return inspector instanceof IdentifiableInspector && this.excluded.contains(((IdentifiableInspector)IdentifiableInspector.class.cast(inspector)).inspectionId());
    }
}

