AJS.namespace("JIRA.WhereIsMyCf");

/**
 * @constructor
 * @extends JIRA.Dialog
 */
JIRA.WhereIsMyCf.WhereIsMyCfDialog = JIRA.Dialog.extend({

    // TODO: use transformer to fill those up from the server
    OPERATION_CREATE: 0,
    OPERATION_EDIT: 1,
    OPERATION_VIEW: 2,


    _getDefaultOptions: function () {
        return AJS.$.extend(this._super(), {
            cached: false,
            id: "whereismycf-dialog",
            widthClass: "large",
            stacked: true
        });
    },


    _setContent: function (content, decorate) {
        var instance = this;
        if (content) {
            this._super(content, decorate);
        } else {
            this._super(AJS.$(JIRA.Templates.Dialogs.WhereIsMyCf.searchPage()), true);
        }
        // init the close link
        this.get$popupContent().find(".cancel").click(function(e) {
            instance.hide();
            e.preventDefault();
        });
        // TODO not sure if applies here
        if (JIRA.Dialog.current === this) {
            var triggerConfig = new JIRA.setFocus.FocusConfiguration();
            triggerConfig.context = this.get$popup()[0];
            triggerConfig.parentElementSelectors = ['.form-body'];
            JIRA.setFocus.pushConfiguration(triggerConfig);
            JIRA.setFocus.triggerFocus();
        }
    },

    _formatActionsResponse: function (response) {

        var res = [];

        if (response) {
            var group = new AJS.GroupDescriptor({
                showLabel: false,
                label: AJS.I18n.getText("whereismycf.dialog.allfields")
            });
            AJS.$(response).each(function() {
                var desc = new AJS.ItemDescriptor({
                    label: this.customFieldName
                });
                desc.properties.cfId = this.customFieldId;
                group.addItem(desc);
            });
            res.push(group);
        }

        return res;
    },

    decorateContent: function () {

        var instance = this,
            issueKey = JIRA.Meta.getIssueKey();

        this.addHeading(AJS.I18n.getText("whereismycf.dialog.title"));

        this.queryControl = new AJS.QueryableDropdownSelect({
            id: "whereismycf",
            element: this.$content.find("#whereismycf-suggestions"),
            ajaxOptions: {
                minQueryLength: 1,
                dataType: "json",
                url: contextPath + "/rest/whereismycf/1.0/fields/all",
                formatResponse: this._formatActionsResponse
            },
            showDropdownButton: true,
            loadOnInit: true // TODO sure about that?
        });
        this.queryControl._handleServerError  = function(smartAjaxResult) {
            var errMsg = JIRA.SmartAjax.buildSimpleErrorContent(smartAjaxResult);
            var errorClass = smartAjaxResult.status === 401?'warning':'error';
            instance._setContent(AJS.$(JIRA.Templates.Dialogs.WhereIsMyCf.errorPage({errrorMessage: errMsg, errorClass: errorClass})), false);
        };
        var originalHandler = this.queryControl.listController.options.selectionHandler;
        this.queryControl.listController.options.selectionHandler = function(event) {
            // use built-in handler from the queryControl
            // this refers to the instance of AJS.List
            originalHandler.call(this,event);
            instance.get$popupContent().find(".field-status-results").remove();
            instance.get$popupContent().find(".field-status-placeholder").append(AJS.$(JIRA.Templates.AdminHelper.Common.loadingStatus()));
            var customField = this.getFocused().data("descriptor");
            AJS.trigger('analyticsEvent', {name: 'adminhelper.whereismycf.field.select'});
            JIRA.SmartAjax.makeRequest({
                url: contextPath + AJS.format(
                    "/rest/whereismycf/1.0/fields/{0}?{1}",
                    customField.properties.cfId,
                    instance.options.context.asRequestParams()),
                complete: function(xhr, textStatus, smartAjaxResult) {
                    if (smartAjaxResult.successful) {
                        // reset the dropdown field
                        instance.queryControl.$field.val("").css("color", "black");
                        // remove the loading status
                        instance.get$popupContent().find(".status-loading").remove();
                        var fieldInfo = smartAjaxResult.data;
                        instance.get$popupContent().find(".field-status-placeholder").append(AJS.$(JIRA.Templates.Dialogs.WhereIsMyCf.resultPage({
                            fieldName: customField.label(),
                            issueType: fieldInfo.issueType,
                            issueKey: fieldInfo.issueKey,
                            project: fieldInfo.projectName,
                            operation: fieldInfo.operation,
                            status: fieldInfo.status,
                            statusLines: processStatusLines(fieldInfo.statusLines),
                            baseUrl: contextPath
                        })));
                    } else {
                        handleError(instance, smartAjaxResult);
                    }
                    instance._positionInCenter();
                }
            });
            return false;
        };

        function processStatusLines(statusLines) {
            if (statusLines.length == 0) {
                return statusLines;
            }

            function processMessages(messages) {
                var processedMsgs = [];
                AJS.$.each(messages, function(index, message) {
                    processedMsgs.push(processMessage(message));
                });
                return processedMsgs;
            }

            function processMessage(message) {
                if (message.parameters.length == 0) {
                    return AJS.escapeHTML(message.message);
                } else {
                    var args = processParams(message.parameters);
                    // need to call AJS.format using apply cause all we have is an array of arguments
                    args.splice(0,0,AJS.escapeHTML(message.message));
                    return AJS.format.apply(this,args);
                }
            }

            function processParams(params) {
                var result = [];
                AJS.$.each(params, function(index, param) {
                    if (param.type=="plain") {
                        result.push(AJS.escapeHTML(param.value));
                    } else if (param.type=="link") {
                        result.push(AJS.format("<a href=''{0}'' target=''_blank''>{1}</a>", AJS.escapeHTML(param.href), AJS.escapeHTML(param.text)));
                    } else if (param.type=="newline") {
                        result.push("<br/>");
                    } else if (param.type=="tagstart") {
                        result.push("<" + param.tagName + ">");
                    } else if (param.type=="tagend") {
                        result.push("</" + param.tagName + ">");
                    } else {
                        throw "Unrecognized parameter type: " + param.type;
                    }
                });
                return result;
            }

            var processed = [];
            AJS.$.each(statusLines, function(index, statusLine) {
                var newStatus = {};
                newStatus.status = statusLine.status;
                newStatus.summary = processMessages(statusLine.summary);
                newStatus.details = processMessages(statusLine.details);
                processed.push(newStatus);
            });
            return processed;
        }

        function handleError(instance, smartAjaxResult) {
            var errorMessages = [];
            var errMsg = JIRA.SmartAjax.buildSimpleErrorContent(smartAjaxResult);
            if (errMsg) {
                errorMessages.push(errMsg);
            } else {
                if (smartAjaxResult.data && smartAjaxResult.data.errorMessages) {
                    errorMessages.push(smartAjaxResult.data.errorMessages);
                }
                if (smartAjaxResult.data && smartAjaxResult.data.errors) {
                    errorMessages.push(smartAjaxResult.data.errors);
                }
            }
            var errorClass = smartAjaxResult.status === 401?'warning':'error';
            instance._setContent(AJS.$(JIRA.Templates.Dialogs.WhereIsMyCf.errorPage({
                errorMessages: errorMessages,
                errorClass: errorClass
            })), false);
        }
    },

    show: function(context) {
        if (context) {
            this.context(context);
        }
        if (!this.options.context) {
            throw "This class must be initialized with 'context' parameter before calling show()";
        }
        this._super();
    },

    context: function(context) {
        if (context) {
            this.options.context = context;
        } else {
            return this.options.context;
        }
    },

    hide: function (undim) {

        if (this._super(undim) === false) {
            return false;
        }
        JIRA.setFocus.popConfiguration();
    }
});

JIRA.WhereIsMyCf.IssueContext = Class.extend({

    init: function(options) {
        this.options = options || {};
    },

    issueKey: function(issueKey) {
        if (issueKey) {
            this.options.issueKey = issueKey;
        } else {
            return this.options.issueKey;
        }
    },

    asRequestParams: function() {
        function exists(prop) {
            return typeof(prop) != 'undefined';
        }

        var params = "atl_token=" + atl_token();
        if (exists(this.options.issueKey)) {
            params += "&issueKey=" + this.options.issueKey;
        }
        if (exists(this.options.projectKey)) {
            params += "&projectKey=" + this.options.projectKey;
        }
        if (exists(this.options.projectId)) {
            params += "&projectId=" + this.options.projectId;
        }
        if (exists(this.options.issueOperation !== undefined)) {
            params += "&issueOperation=" + this.options.issueOperation;
        }
        if (exists(this.options.issueTypeId)) {
            params += "&issueTypeId=" + this.options.issueTypeId;
        }
        return params;
    }


});

