/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageParameter;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.rest.StatusProcessor;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class NotificationInfoJson {
    public static final String STATUS_GREEN = "green";
    public static final String STATUS_RED = "red";
    public static final String PARAM_TYPE_PLAIN = "plain";
    public static final String PARAM_TYPE_LINK = "link";
    public static final String PARAM_TYPE_NEWLINE = "newline";
    public static final String PARAM_TYPE_TAG_START = "tagstart";
    public static final String PARAM_TYPE_TAG_END = "tagend";
    private static final Function<InspectionMessage, MessageBean> MESSAGE_BEAN_FACTORY = new Function<InspectionMessage, MessageBean>(){

        public MessageBean apply(InspectionMessage inspectionMsg) {
            MessageBean messageBean = new MessageBean();
            messageBean.message = inspectionMsg.template();
            messageBean.parameters = Iterables.transform(inspectionMsg.parameters(), (Function)MESSAGE_PARAM_FACTORY);
            return messageBean;
        }
    };
    private static final Function<InspectionMessageParameter, Object> MESSAGE_PARAM_FACTORY = new Function<InspectionMessageParameter, Object>(){

        public Object apply(InspectionMessageParameter input) {
            return ParamTypeResolver.find(input).createBean(input);
        }
    };

    private NotificationInfoJson() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    static InfoBean createInfoBean(Iterable<InspectionNote> notes, NotificationInspectionContext context) {
        return new InfoBean(notes, context);
    }

    static String determineStatus(InspectionNote.Status status) {
        return status == InspectionNote.Status.OK ? STATUS_GREEN : STATUS_RED;
    }

    static Iterable<StatusLine> createStatusLines(Iterable<InspectionNote> notes) {
        ArrayList inspectionNoteList = Lists.newArrayList(notes);
        Collections.sort(inspectionNoteList, new Comparator<InspectionNote>(){

            @Override
            public int compare(InspectionNote left, InspectionNote right) {
                if (left.status().equals((Object)right.status())) {
                    return 0;
                }
                switch (left.status()) {
                    case OK: {
                        return -1;
                    }
                }
                return 1;
            }
        });
        ImmutableList.Builder answer = ImmutableList.builder();
        for (InspectionNote issue : inspectionNoteList) {
            answer.add((Object)NotificationInfoJson.createStatusLine(issue));
        }
        return answer.build();
    }

    static StatusLine createStatusLine(InspectionNote issue) {
        StatusLine statusLine = new StatusLine();
        statusLine.status = NotificationInfoJson.determineStatus(issue.status());
        statusLine.summary = Iterables.transform(issue.summary(), MESSAGE_BEAN_FACTORY);
        statusLine.details = Iterables.transform(issue.details(), MESSAGE_BEAN_FACTORY);
        return statusLine;
    }

    private static enum ParamTypeResolver {
        PLAIN(InspectionMessageParameter.Type.PLAIN){

            @Override
            Object createBean(InspectionMessageParameter parameter) {
                int size = Iterables.size(parameter.values());
                Preconditions.checkArgument((size == 1 ? 1 : 0) != 0, (Object)("Plain parameter should have exactly one value, but was <" + size + ">"));
                return new PlainParam((String)Iterables.get(parameter.values(), (int)0));
            }
        }
        ,
        LINK(InspectionMessageParameter.Type.LINK){

            @Override
            Object createBean(InspectionMessageParameter parameter) {
                int size = Iterables.size(parameter.values());
                Preconditions.checkArgument((size == 2 ? 1 : 0) != 0, (Object)("Plain parameter should have exactly two values, but was <" + size + ">"));
                return new LinkParam((String)Iterables.get(parameter.values(), (int)0), (String)Iterables.get(parameter.values(), (int)1));
            }
        }
        ,
        NEW_LINE(InspectionMessageParameter.Type.NEWLINE){

            @Override
            Object createBean(InspectionMessageParameter parameter) {
                int size = Iterables.size(parameter.values());
                Preconditions.checkArgument((size == 0 ? 1 : 0) != 0, (Object)("Newline parameter should have no values, but was <" + size + ">"));
                return new NewLineParam();
            }
        }
        ,
        TAG_START(InspectionMessageParameter.Type.TAG_START){

            @Override
            Object createBean(InspectionMessageParameter parameter) {
                int size = Iterables.size(parameter.values());
                Preconditions.checkArgument((size == 1 ? 1 : 0) != 0, (Object)("Tag start parameter should have exactly one value, but was <" + size + ">"));
                return new TagStartParam((String)Iterables.get(parameter.values(), (int)0));
            }
        }
        ,
        TAG_END(InspectionMessageParameter.Type.TAG_END){

            @Override
            Object createBean(InspectionMessageParameter parameter) {
                int size = Iterables.size(parameter.values());
                Preconditions.checkArgument((size == 1 ? 1 : 0) != 0, (Object)("Tag end parameter should have exactly one value, but was <" + size + ">"));
                return new TagEndParam((String)Iterables.get(parameter.values(), (int)0));
            }
        };

        private final InspectionMessageParameter.Type matchingType;

        static ParamTypeResolver find(InspectionMessageParameter parameter) {
            for (ParamTypeResolver resolver : ParamTypeResolver.values()) {
                if (resolver.matchingType != parameter.type()) continue;
                return resolver;
            }
            throw new IllegalStateException("No resolver for type " + (Object)((Object)parameter.type()) + " found");
        }

        private ParamTypeResolver(InspectionMessageParameter.Type matchingType) {
            this.matchingType = matchingType;
        }

        abstract Object createBean(InspectionMessageParameter var1);
    }

    public static class CfBean {
        public String customFieldId;
        public String customFieldName;

        public CfBean() {
        }

        public CfBean(String customFieldId, String customFieldName) {
            this.customFieldId = customFieldId;
            this.customFieldName = customFieldName;
        }
    }

    public static class TagEndParam
    extends AbstractParam {
        public String tagName;

        protected TagEndParam() {
            super(NotificationInfoJson.PARAM_TYPE_TAG_END);
        }

        public TagEndParam(String tagName) {
            this();
            this.tagName = tagName;
        }
    }

    public static class TagStartParam
    extends AbstractParam {
        public String tagName;

        protected TagStartParam() {
            super(NotificationInfoJson.PARAM_TYPE_TAG_START);
        }

        public TagStartParam(String tagName) {
            this();
            this.tagName = tagName;
        }
    }

    public static class NewLineParam
    extends AbstractParam {
        public NewLineParam() {
            super(NotificationInfoJson.PARAM_TYPE_NEWLINE);
        }
    }

    public static class LinkParam
    extends AbstractParam {
        public String text;
        public String href;

        protected LinkParam() {
            super(NotificationInfoJson.PARAM_TYPE_LINK);
        }

        public LinkParam(String text, String href) {
            this();
            this.text = text;
            this.href = href;
        }
    }

    public static class PlainParam
    extends AbstractParam {
        public String value;

        public PlainParam(String value) {
            this();
            this.value = value;
        }

        public PlainParam() {
            super(NotificationInfoJson.PARAM_TYPE_PLAIN);
        }
    }

    public static abstract class AbstractParam {
        public String type;

        protected AbstractParam(String type) {
            this.type = type;
        }
    }

    public static class MessageBean {
        public String message;
        public Iterable<Object> parameters;
    }

    public static class StatusLine {
        public String status;
        public Iterable<MessageBean> summary;
        public Iterable<MessageBean> details;
    }

    public static class InfoBean {
        public String status;
        public Iterable<StatusLine> statusLines;
        public String projectName;
        public String projectKey;
        public String issueKey;
        public String eventName;
        public String notificationSchemeName;
        public String username;
        public String userDisplayName;
        public Boolean userNotifyOwnChanges;

        public InfoBean() {
        }

        public InfoBean(Iterable<InspectionNote> notes, NotificationInspectionContext context) {
            this.status = NotificationInfoJson.determineStatus(StatusProcessor.or(notes));
            this.projectName = context.project().getName();
            this.projectKey = context.project().getKey();
            this.issueKey = context.issue().getKey();
            this.statusLines = NotificationInfoJson.createStatusLines(notes);
            this.username = UserHelper.getUsername(context.user());
            this.userDisplayName = UserHelper.getDisplayName(context.user());
            this.userNotifyOwnChanges = context.notifyOwnChanges();
            this.eventName = context.eventTypeName();
            this.notificationSchemeName = context.notificationScheme() != null ? context.notificationScheme().getName() : "No Notification Scheme";
        }
    }
}

