/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.NotificationInspector;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AffectedVersionsSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AlwaysVisibleOnViewIssueInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AttachmentSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AttachmentValueOnViewInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.CommentSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ComponentsSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ConditionalInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ContextScopeInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.DisplaysOnViewWithNoValueInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.FieldConfigurationInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.FixVersionsSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ImmutableSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.InternalSystemFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.LinkedIssuesInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.PermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ProjectInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ResolutionDateValueInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ScreenInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.SecurityLevelFieldInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.TimeTrackingInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.ViewOperationValueInspector;
import com.atlassian.jira.customfieldhelper.rest.InspectorFactory;
import com.atlassian.jira.customfieldhelper.rest.NotificationInspectors;
import com.atlassian.jira.customfieldhelper.rest.PermissionInspectors;
import com.atlassian.jira.customfieldhelper.versions.JiraVersionChecker;
import com.atlassian.jira.customfieldhelper.versions.JiraVersions;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.CreatedSystemField;
import com.atlassian.jira.issue.fields.DescriptionSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.LabelsSystemField;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.StatusSystemField;
import com.atlassian.jira.issue.fields.UpdatedSystemField;
import com.atlassian.jira.issue.fields.WorkRatioSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultInspectorFactory
implements InspectorFactory {
    private final AttachmentManager attachmentManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final PermissionManager permissionManager;
    private final SchemePermissions schemePermissions;
    private final JiraVersionChecker versionChecker;
    private final LinkedIssuesInspector linkedIssuesInspector;
    private final TimeTrackingInspector timeTrackingInspector;
    private final ComponentsSystemFieldInspector componentsInspector;
    private final FixVersionsSystemFieldInspector fixVersionsInspector;
    private final AffectedVersionsSystemFieldInspector affectedVersionsInspector;
    private final Iterable<FieldInspector<? extends Field>> fieldInspectors;
    private final PermissionInspectors permissionInspectors;
    private final NotificationInspectors notificationInspectors;

    @Autowired
    public DefaultInspectorFactory(AttachmentManager attachmentManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, PermissionManager permissionManager, JiraVersionChecker versionChecker, LinkedIssuesInspector linkedIssuesInspector, TimeTrackingInspector timeTrackingInspector, ComponentsSystemFieldInspector componentsInspector, FixVersionsSystemFieldInspector fixVersionsSystemField, AffectedVersionsSystemFieldInspector affectedVersionsInspector, PermissionInspectors permissionInspectors, NotificationInspectors notificationInspectors) {
        this.attachmentManager = attachmentManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.permissionManager = permissionManager;
        this.versionChecker = versionChecker;
        this.notificationInspectors = notificationInspectors;
        this.schemePermissions = (SchemePermissions)ComponentAccessor.getComponent(SchemePermissions.class);
        this.linkedIssuesInspector = linkedIssuesInspector;
        this.timeTrackingInspector = timeTrackingInspector;
        this.componentsInspector = componentsInspector;
        this.fixVersionsInspector = fixVersionsSystemField;
        this.affectedVersionsInspector = affectedVersionsInspector;
        this.fieldInspectors = this.createFieldInspectors();
        this.permissionInspectors = permissionInspectors;
    }

    private Iterable<FieldInspector<? extends Field>> createFieldInspectors() {
        return ImmutableList.of((Object)this.linkedIssuesInspector, (Object)this.timeTrackingInspector, (Object)this.componentsInspector, (Object)this.fixVersionsInspector, (Object)this.affectedVersionsInspector, InternalSystemFieldInspector.forFieldType(WorkRatioSystemField.class), AlwaysVisibleOnViewIssueInspector.forFieldType(IssueTypeSystemField.class), ImmutableSystemFieldInspector.forFieldType(StatusSystemField.class), ImmutableSystemFieldInspector.forFieldType(CreatedSystemField.class), ImmutableSystemFieldInspector.forFieldType(UpdatedSystemField.class), ImmutableSystemFieldInspector.forFieldTypeAndExcludedOps(ResolutionDateSystemField.class, new IssueOperation[]{IssueOperations.VIEW_ISSUE_OPERATION}), DefaultInspectorFactory.disableNoValueOnView(AssigneeSystemField.class), (Object[])new FieldInspector[]{DefaultInspectorFactory.disableNoValueOnView(CommentSystemField.class), DefaultInspectorFactory.disableNoValueOnView(ResolutionSystemField.class), DefaultInspectorFactory.disableNoValueOnView(AffectedVersionsSystemField.class), DefaultInspectorFactory.disableNoValueOnView(FixVersionsSystemField.class), DefaultInspectorFactory.disableNoValueOnView(ComponentsSystemField.class), DefaultInspectorFactory.disableNoValueOnView(SecurityLevelSystemField.class), DefaultInspectorFactory.disableNoValueOnView(LabelsSystemField.class), DefaultInspectorFactory.disableNoValueOnView(ReporterSystemField.class), this.onlyOnVersion(JiraVersions.jira51(), DefaultInspectorFactory.disableNoValueOnView(DescriptionSystemField.class)), new ProjectInspector(), new CommentSystemFieldInspector(), new ResolutionDateValueInspector(), new AttachmentValueOnViewInspector(this.attachmentManager), new AttachmentSystemFieldInspector(this.attachmentManager), new ContextScopeInspector(), new FieldConfigurationInspector(this.fieldLayoutManager), new ScreenInspector(this.issueTypeScreenSchemeManager), new ViewOperationValueInspector(), new SecurityLevelFieldInspector(this.issueSecuritySchemeManager, this.permissionManager), this.newPermissionInspector("assignee", 13), this.newPermissionInspector("attachment", 19), this.newPermissionInspector("comment", 15), this.newPermissionInspector("duedate", 28), this.newPermissionInspector("fixVersions", 14), this.newPermissionInspector("reporter", 30), this.newPermissionInspector("worklog", 20)});
    }

    static <F extends Field> DisplaysOnViewWithNoValueInspector<F> disableNoValueOnView(Class<F> fieldType) {
        return DisplaysOnViewWithNoValueInspector.forFieldType(fieldType);
    }

    private <F extends Field> ConditionalInspector<F> onlyOnVersion(int[] version, FieldInspector<F> inspector) {
        return ConditionalInspector.conditional(inspector, JiraVersions.isEqualOrLaterThan(this.versionChecker, version));
    }

    private PermissionInspector newPermissionInspector(String fieldId, int permissionId) {
        return new PermissionInspector(this.permissionManager, fieldId, permissionId, this.getPermissionName(permissionId));
    }

    private String getPermissionName(int permissionId) {
        return ((Permission)this.schemePermissions.getSchemePermissions().get(permissionId)).getName();
    }

    @Override
    public Iterable<FieldInspector<? extends Field>> getFieldInspectors() {
        return this.fieldInspectors;
    }

    @Override
    public Iterable<ProjectPermissionInspector> getPermissionInspectors() {
        return this.permissionInspectors.all();
    }

    @Override
    public Iterable<NotificationInspector> getNotificationInspectors() {
        return this.notificationInspectors.all();
    }
}

