/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SchemeGroupInspector {
    private final GroupManager groupManager;
    private final String type;
    private final I18nResolver i18nResolver;

    public SchemeGroupInspector(GroupManager groupManager, String type, I18nResolver i18nResolver) {
        this.groupManager = groupManager;
        this.type = type;
        this.i18nResolver = i18nResolver;
    }

    public Iterable<InspectionNote> inspect(Iterable<SchemeEntity> entities, InspectionContext context) {
        ArrayList notes = Lists.newArrayList();
        List<String> groupNames = this.getGroupNames(entities);
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (context.isAnonymous()) {
            if (groupNames.contains(null)) {
                notes.add(InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.group.anonymous.ok")).build());
            } else {
                notes.add(InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.group.anonymous.problem")).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.group.anonymous.problem.fix")).build());
            }
        } else {
            List<String> groupsUserIsIn = this.getGroupsUserIsIn(context.user(), groupNames);
            if (!groupsUserIsIn.isEmpty()) {
                notes.add(InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.group.ok." + (groupsUserIsIn.size() > 1 ? "plural" : "singular")).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(groupsUserIsIn, (String)", ")).build()).build());
            } else {
                notes.add(InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.group.problem." + (groupNames.size() > 1 ? "plural" : "singular")).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(groupNames, (String)", ")).build()).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.group.problem.fix").newI18nLinkParameter().pathKey("permissionhelper.inspection.link.editusergroups").urlParams(UserHelper.getUsername(context)).textKey("permissionhelper.inspection.viewissue.group.linktext.editusergroups").textParams(UserHelper.getDisplayName(context)).add().build()).build());
            }
        }
        return ImmutableList.copyOf((Collection)notes);
    }

    private List<String> getGroupNames(Iterable<SchemeEntity> entities) {
        ArrayList groupNames = Lists.newArrayList();
        for (SchemeEntity schemeEntity : Iterables.filter(entities, SchemeTypes.isOfType(this.type))) {
            String groupName = schemeEntity.getParameter();
            groupNames.add(groupName);
        }
        return groupNames;
    }

    private List<String> getGroupsUserIsIn(User user, List<String> groupNames) {
        ArrayList result = Lists.newArrayListWithCapacity((int)groupNames.size());
        for (String groupName : groupNames) {
            if (groupName == null) {
                result.add(this.i18nResolver.getText("admin.common.words.anyone"));
                continue;
            }
            Group group = this.groupManager.getGroup(groupName);
            if (!this.groupManager.isUserInGroup(user, group)) continue;
            result.add(groupName);
        }
        return result;
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.group.summary");
    }
}

