/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeProjectRoleInspector;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeProjectRoleInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;
    private final SchemeProjectRoleInspector inspector;

    @Autowired
    public PermissionSchemeProjectRoleInspector(PermissionSchemeManager permissionSchemeManager, ProjectRoleManager projectRoleManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.inspector = new SchemeProjectRoleInspector(projectRoleManager, "projectrole");
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        List entities = permissionScheme.getEntitiesByType((Object)context.permission().getId());
        return this.inspector.inspect(entities, context);
    }
}

