/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.GroupCfInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.groups.GroupManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeGroupCustomFieldInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;
    private final GroupCfInspector groupCfInspector;

    @Autowired
    public PermissionSchemeGroupCustomFieldInspector(PermissionSchemeManager permissionSchemeManager, CustomFieldManager customFieldManager, GroupManager groupManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.groupCfInspector = new GroupCfInspector(groupManager, customFieldManager);
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        List entities = permissionScheme.getEntitiesByType((Object)context.permission().getId());
        return SchemeTypes.forEach(entities, context, "groupCF", this.groupCfInspector);
    }
}

