/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.notification;

import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.notification.AbstractNotificationInspector;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.mail.MailException;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationMailServerInspector
extends AbstractNotificationInspector {
    @Autowired
    public NotificationMailServerInspector(NotificationSchemeManager notificationSchemeManager) {
        super(notificationSchemeManager);
    }

    @Override
    @Nonnull
    protected Iterable<InspectionNote> inspectEntities(@Nonnull Iterable<SchemeEntity> entities, @Nonnull NotificationInspectionContext context) {
        try {
            if (!this.notificationSchemeManager.isHasMailServer()) {
                context.excludeAll();
                return Collections.singletonList(InspectionNote.problem(InspectionMessageBuilder.newSimpleMessage(context, "adminhelper.notification.inspection.mailserver.summary")).addDetails(InspectionMessageBuilder.forContext(context).templateKey("adminhelper.notification.inspection.mailserver.details").addLinkParameterFromI18n("adminhelper.notification.inspection.mailserver.linktext", "adminhelper.notification.inspection.link.mailserver", new Object[0]).build()).build());
            }
            return Collections.emptyList();
        }
        catch (MailException e) {
            return Collections.emptyList();
        }
    }
}

