/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.adminhelper.web;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONString;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class NotificationEventsTransformer
implements WebResourceTransformer {
    private static final String SUBSTITUTION = "NOTIFICATION_EVENTS_SUBSTITUTION";
    private static final Pattern PATTERN_REGEX = Pattern.compile("NOTIFICATION_EVENTS_SUBSTITUTION", 16);
    private static final Long DEFAULT_EVENT_ID = EventType.ISSUE_CREATED_ID;
    private final JiraAuthenticationContext authenticationContext;
    private final EventTypeManager eventTypeManager;
    private final String eventJson;

    public NotificationEventsTransformer(JiraAuthenticationContext authenticationContext, EventTypeManager eventTypeManager) {
        this.authenticationContext = authenticationContext;
        this.eventTypeManager = eventTypeManager;
        this.eventJson = this.createJson();
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String s, DownloadableResource downloadableResource) {
        return new PermissionsInterpolatedResource(downloadableResource);
    }

    private String createJson() {
        Collection eventJsons = Collections2.transform(this.getAllEvents(), (Function)new Function<EventType, EventJson>(){

            public EventJson apply(@Nullable EventType eventType) {
                return new EventJson(eventType);
            }
        });
        return new JSONArray(eventJsons).toString();
    }

    private Collection<EventType> getAllEvents() {
        return this.eventTypeManager.getEventTypes();
    }

    private class EventJson
    implements JSONString {
        private final EventType eventType;

        private EventJson(EventType eventType) {
            this.eventType = eventType;
        }

        public String toJSONString() {
            HashMap eventMap = Maps.newHashMap();
            eventMap.put("id", this.eventType.getId());
            eventMap.put("name", this.getName());
            if (DEFAULT_EVENT_ID.equals(this.eventType.getId())) {
                eventMap.put("isDefault", true);
            }
            return new JSONObject((Map)eventMap).toString();
        }

        private String getName() {
            String name = this.eventType.getTranslatedName(NotificationEventsTransformer.this.authenticationContext.getLoggedInUser());
            if (name != null) {
                name = name.replace("\"", "\\\"");
            }
            return name;
        }
    }

    class PermissionsInterpolatedResource
    extends CharSequenceDownloadableResource {
        public PermissionsInterpolatedResource(DownloadableResource originalResource) {
            super(originalResource);
        }

        protected CharSequence transform(CharSequence original) {
            if (original == null) {
                return null;
            }
            Matcher matcher = PATTERN_REGEX.matcher(original);
            return matcher.replaceAll(NotificationEventsTransformer.this.eventJson);
        }
    }
}

