/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.performance.events;

import com.atlassian.analytics.api.annotations.EventName;
import java.util.Map;

public class PerformanceEvent {
    private Type type;
    private long duration;
    private boolean success;
    private Map<String, Object> parameters;

    public PerformanceEvent(Type type, long duration, boolean success, Map<String, Object> parameters) {
        this.type = type;
        this.duration = duration;
        this.success = success;
        this.parameters = parameters;
    }

    public Type getType() {
        return this.type;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @EventName
    public String getEventName() {
        return String.format("jira.inform.performance.event.%s", this.getType().toString());
    }

    public String toString() {
        return "PerformanceEvent{type=" + (Object)((Object)this.type) + ", duration=" + this.duration + " ms, success=" + this.success + ", parameters=" + this.parameters + '}';
    }

    public static enum Type {
        JIRA_EVENT_PROCESSING,
        CONVERTING_TO_DB,
        SAVING_TO_DB,
        FETCHING_FROM_DB,
        BATCHING_JOB,
        BATCHING_JOB_BATCH_PROCESSING,
        BATCHING_JOB_BATCH_PROCESSING_ALL,
        CLEANUP_JOB;

    }
}

