/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.managers;

import com.atlassian.jira.plugins.inform.api.events.EventSearchParams;
import com.atlassian.jira.plugins.inform.api.events.EventStatus;
import com.atlassian.jira.plugins.inform.api.events.UpdateStatusParams;
import com.atlassian.jira.plugins.inform.events.mapping.querydsl.Tables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EventSearcher {
    List<Predicate> predicates(EventSearchParams searchParams) {
        EventSearchParams.RecipientData recipientData;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotEmpty((CharSequence)searchParams.getAction())) {
            predicates.add((Predicate)Tables.EVENT.ACTION.eq((Object)searchParams.getAction()));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchParams.getEventBundleId())) {
            predicates.add((Predicate)Tables.EVENT.EVENT_BUNDLE_ID.eq((Object)searchParams.getEventBundleId()));
        }
        if ((recipientData = searchParams.getRecipientData()) != null && !recipientData.isEmpty()) {
            ArrayList<Object> recipientPredicates = new ArrayList<Object>();
            recipientPredicates.add(Tables.EVENT_RECIPIENT.EVENT_ID.eq(Tables.EVENT.ID));
            recipientPredicates.addAll(this.predicates(recipientData));
            BooleanExpression statusForConsumerWithValue = ((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.EVENT_RECIPIENT.ID).from((Expression)Tables.EVENT_RECIPIENT)).where(recipientPredicates.toArray(new Predicate[0]))).exists();
            predicates.add((Predicate)statusForConsumerWithValue);
        }
        if (!searchParams.getUserKeys().isEmpty()) {
            predicates.add((Predicate)Tables.EVENT.USER_KEY.in(searchParams.getUserKeys()));
        }
        if (!searchParams.getEventTypes().isEmpty()) {
            predicates.add((Predicate)Tables.EVENT.EVENT_TYPE.in(searchParams.getEventTypes()));
        }
        if (searchParams.getIdMin() != null) {
            predicates.add((Predicate)Tables.EVENT.ID.goe((Number)searchParams.getIdMin()));
        }
        if (searchParams.getIdMax() != null) {
            predicates.add((Predicate)Tables.EVENT.ID.loe((Number)searchParams.getIdMax()));
        }
        if (!searchParams.getIds().isEmpty()) {
            predicates.add((Predicate)Tables.EVENT.ID.in(searchParams.getIds()));
        }
        searchParams.getEventParameters().stream().filter(EventSearchParams.EventParameter::isValid).forEach(ep -> {
            BooleanExpression predicate = Tables.EVENT_PARAMETER.EVENT_ID.eq(Tables.EVENT.ID);
            if (ep.getName() != null) {
                predicate = predicate.and((Predicate)Tables.EVENT_PARAMETER.NAME.eq((Object)ep.getName()));
            }
            if (ep.getValue() != null) {
                predicate = predicate.and((Predicate)Tables.EVENT_PARAMETER.VALUE.like(ep.getValue()));
            }
            predicates.add((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.EVENT_PARAMETER.ID).from((Expression)Tables.EVENT_PARAMETER)).where((Predicate)predicate)).exists());
        });
        return predicates;
    }

    List<Predicate> predicates(EventSearchParams.RecipientData recipientData) {
        if (recipientData == null || recipientData.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Predicate> recipientPredicates = new ArrayList<Predicate>();
        HashSet<EventStatus> statuses = new HashSet<EventStatus>();
        if (recipientData.getStatus() != null) {
            statuses.add(recipientData.getStatus());
        }
        statuses.addAll(recipientData.getStatuses());
        if (!statuses.isEmpty()) {
            recipientPredicates.add((Predicate)Tables.EVENT_RECIPIENT.STATUS.in((Collection)statuses.stream().map(Object::toString).collect(Collectors.toSet())));
        }
        if (recipientData.getEventConsumer() != null) {
            recipientPredicates.add((Predicate)Tables.EVENT_RECIPIENT.CONSUMER_NAME.eq((Object)recipientData.getEventConsumer()));
        }
        if (recipientData.getSendDateFrom() != null) {
            recipientPredicates.add((Predicate)Tables.EVENT_RECIPIENT.SEND_DATE.goe((Comparable)Timestamp.from(recipientData.getSendDateFrom())));
        }
        if (recipientData.getSendDateTo() != null) {
            recipientPredicates.add((Predicate)Tables.EVENT_RECIPIENT.SEND_DATE.loe((Comparable)Timestamp.from(recipientData.getSendDateTo())));
        }
        if (CollectionUtils.isNotEmpty((Collection)recipientData.getRecipients())) {
            recipientPredicates.add((Predicate)Tables.EVENT_RECIPIENT.USER_KEY.in(this.getRecipientUserKeys(recipientData)));
        }
        return recipientPredicates;
    }

    private Collection<String> getRecipientUserKeys(EventSearchParams.RecipientData recipientData) {
        if (recipientData.isLimitRecipients()) {
            return recipientData.getRecipients().stream().limit(2000L).collect(Collectors.toSet());
        }
        return recipientData.getRecipients();
    }

    List<Predicate> predicates(UpdateStatusParams updateStatusParams, int maxParameterSize) {
        boolean shouldBatchParameters;
        if (updateStatusParams == null || updateStatusParams.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        boolean bl = shouldBatchParameters = updateStatusParams.size() > maxParameterSize;
        if (shouldBatchParameters) {
            int parametersLeft = this.assertParametersLeft(updateStatusParams, maxParameterSize);
            int batchSize = this.getBatchSize(updateStatusParams, parametersLeft);
            List eventIdsPartitions = this.fillIfEmpty(Lists.partition(new ArrayList(updateStatusParams.getEventIds()), (int)batchSize));
            List userKeysPartitions = this.fillIfEmpty(Lists.partition(new ArrayList(updateStatusParams.getUserKeys()), (int)batchSize));
            List recipientIdsPartitions = this.fillIfEmpty(Lists.partition(new ArrayList(updateStatusParams.getRecipientIds()), (int)batchSize));
            for (List<Long> list : eventIdsPartitions) {
                for (List<String> list2 : userKeysPartitions) {
                    for (List<Long> list3 : recipientIdsPartitions) {
                        predicates.add((Predicate)this.getPredicate(updateStatusParams.getConsumerNames(), updateStatusParams.getStatuses(), list, list2, list3));
                    }
                }
            }
        } else {
            predicates.add((Predicate)this.getPredicate(updateStatusParams.getConsumerNames(), updateStatusParams.getStatuses(), updateStatusParams.getEventIds(), updateStatusParams.getUserKeys(), updateStatusParams.getRecipientIds()));
        }
        return predicates;
    }

    private BooleanExpression getPredicate(Collection<String> consumerNames, Collection<EventStatus> statuses, Collection<Long> eventIds, Collection<String> userKeys, Collection<Long> recipientIds) {
        BooleanExpression predicate = Expressions.asBoolean((boolean)true).isTrue();
        if (!consumerNames.isEmpty()) {
            predicate = predicate.and((Predicate)Tables.EVENT_RECIPIENT.CONSUMER_NAME.in(consumerNames));
        }
        if (!statuses.isEmpty()) {
            predicate = predicate.and((Predicate)Tables.EVENT_RECIPIENT.STATUS.in((Collection)statuses.stream().map(Enum::toString).collect(Collectors.toSet())));
        }
        if (!eventIds.isEmpty()) {
            predicate = predicate.and((Predicate)Tables.EVENT_RECIPIENT.EVENT_ID.in(eventIds));
        }
        if (!userKeys.isEmpty()) {
            predicate = predicate.and((Predicate)Tables.EVENT_RECIPIENT.USER_KEY.in(userKeys));
        }
        if (!recipientIds.isEmpty()) {
            predicate = predicate.and((Predicate)Tables.EVENT_RECIPIENT.ID.in(recipientIds));
        }
        return predicate;
    }

    private int assertParametersLeft(UpdateStatusParams updateStatusParams, int maxParameterSize) {
        int parametersLeft = maxParameterSize - updateStatusParams.getConsumerNames().size() - updateStatusParams.getStatuses().size();
        if (parametersLeft < 3) {
            throw new RuntimeException("Too many parameters used for consumer name and statuses: " + (updateStatusParams.getConsumerNames().size() + updateStatusParams.getStatuses().size()));
        }
        return parametersLeft;
    }

    private int getBatchSize(UpdateStatusParams updateStatusParams, int parametersLeft) {
        int batchDivider = 3;
        if (updateStatusParams.getEventIds().isEmpty()) {
            --batchDivider;
        }
        if (updateStatusParams.getUserKeys().isEmpty()) {
            --batchDivider;
        }
        if (updateStatusParams.getRecipientIds().isEmpty()) {
            --batchDivider;
        }
        return parametersLeft / Math.max(batchDivider, 1);
    }

    private <T> List<List<T>> fillIfEmpty(List<List<T>> partition) {
        if (partition.isEmpty()) {
            return ImmutableList.of((Object)ImmutableList.of());
        }
        return partition;
    }
}

