/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.jira.plugins.inform.api.events.MailLoggerFactory;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventThreadPool
implements Consumer<Runnable>,
InitializingBean,
DisposableBean {
    private static final Logger LOG = MailLoggerFactory.getOutgoingMailLogger(EventThreadPool.class);
    private static final org.apache.log4j.Logger THREAD_LOCAL_UTIL_LOG = org.apache.log4j.Logger.getLogger(EventThreadPool.class);
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    public static final int MAXIMUM_POOL_SIZE = 5;
    private ExecutorService executorService;
    private final JiraThreadLocalUtil jiraThreadLocalUtil;

    @Autowired
    public EventThreadPool(@ComponentImport JiraThreadLocalUtil jiraThreadLocalUtil) {
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    @Override
    public void accept(Runnable runnable) {
        this.executorService.submit(this.wrapThreadLocalSafe(runnable));
    }

    private Runnable wrapThreadLocalSafe(Runnable runnable) {
        return () -> {
            this.jiraThreadLocalUtil.preCall();
            try {
                runnable.run();
            }
            finally {
                this.jiraThreadLocalUtil.postCall(THREAD_LOCAL_UTIL_LOG, null);
            }
        };
    }

    private ExecutorService initExecutor() {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(10000);
        RejectedExecutionHandler callerRunsPolicy = (runnable, executor) -> {
            LOG.warn("Queue size exceeded, running task in caller thread - this may affect UI performance");
            runnable.run();
        };
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("JIRA-INFORM-Thread-%d");
        return new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, queue, builder.build(), callerRunsPolicy);
    }

    public void destroy() throws Exception {
        this.shutdownExecutor();
    }

    private void shutdownExecutor() {
        LOG.debug("shutting down EventThreadPool executor");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOG.debug("shutting down EventThreadPool executor (2)");
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOG.error("EventThreadPool ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService = this.initExecutor();
    }
}

