/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.plugins.inform.events.listener.EventThreadPool;
import com.atlassian.jira.plugins.inform.events.listener.JiraEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="asyncJiraEventListener")
public class AsyncJiraEventListener
implements JiraEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncJiraEventListener.class);
    private final JiraEventListener delegate;
    private final EventThreadPool eventThreadPool;

    @Autowired
    public AsyncJiraEventListener(JiraEventListener delegate, EventThreadPool eventThreadPool) {
        this.delegate = delegate;
        this.eventThreadPool = eventThreadPool;
    }

    @Override
    public void handleIssueEventBundle(OnCommitIssueEventBundle bundle) {
        this.eventThreadPool.accept(() -> this.delegate.handleIssueEventBundle(bundle));
    }

    @Override
    public void handleIssueEvent(OnCommitIssueEvent issueEvent) {
        this.eventThreadPool.accept(() -> this.delegate.handleIssueEvent(issueEvent));
    }
}

