/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.cleanup;

import com.atlassian.jira.plugins.inform.api.events.EventCleanupService;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanupJob
implements JobRunner {
    private static final Logger logger = LoggerFactory.getLogger(CleanupJob.class);
    private final EventCleanupService eventCleanupService;
    private final MeasurementWorkerFactory measurementWorkerFactory;

    @Autowired
    public CleanupJob(EventCleanupService eventCleanupService, MeasurementWorkerFactory measurementWorkerFactory) {
        this.eventCleanupService = eventCleanupService;
        this.measurementWorkerFactory = measurementWorkerFactory;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            this.measurementWorkerFactory.ofType(PerformanceEvent.Type.CLEANUP_JOB).measure(parameters -> {
                long count = this.eventCleanupService.cleanup();
                parameters.put("cleanCount", count);
                return null;
            });
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            logger.error("Exception during cleanup job", (Throwable)e);
            return JobRunnerResponse.failed((String)"Exception during cleanup job");
        }
    }
}

