/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.plugins.inform.api.events.EventSearchParams;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.events.mapping.querydsl.Tables;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.Collection;
import javax.annotation.Nonnull;

public class EventUserAnonymizationHandler
implements UserKeyChangeHandler {
    private final EventManager eventManager;
    private final DatabaseAccessor databaseAccessor;

    public EventUserAnonymizationHandler(EventManager eventManager, DatabaseAccessor databaseAccessor) {
        this.eventManager = eventManager;
        this.databaseAccessor = databaseAccessor;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter parameter) {
        long matches = this.eventManager.count(EventSearchParams.newBuilder().userKeys((Collection)ImmutableList.of((Object)parameter.getOriginal())).build());
        if (matches > 0L) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(matches)).descriptionKey("issue.update.event.user.reference").build());
        }
        return ImmutableList.of();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter parameter) {
        try {
            this.databaseAccessor.run(connection -> connection.update((RelationalPath)Tables.EVENT).set((Path)Tables.EVENT.USER_KEY, (Object)parameter.getTarget()).where((Predicate)Tables.EVENT.USER_KEY.eq((Object)parameter.getOriginal())).execute(), OnRollback.NOOP);
        }
        finally {
            ContextUtil.updateProgress((Context)parameter.getContext(), (int)this.getNumberOfTasks(parameter));
        }
        return new ServiceResultImpl();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return 1;
    }
}

