require([
    "jquery",
    "wrm/context-path",
    "jira/ajs/ajax/smart-ajax",
    "jira/util/logger",
    "jira/util/formatter",
    "jira/analytics",
    "jira/flag"
], function (
    $,
    ContextPath,
    SmartAjax,
    Logger,
    formatter,
    Analytics,
    JiraFlag
) {
    $(function () {
        document.querySelector("section.configure-admin-batching form").addEventListener("submit", savePreferences);

        var batchingEnabledChanged = false;
        var intervalChanged = false;

        $("input[name='batching-switch']").on('change', onBatchingEnabledChanged);
        $('#custom-interval').on('change', onIntervalChanged);

        function toggleDelayConfigView(show) {
            const delayForm = $('#batched-notifications-config');
            if (show) {
                delayForm.show();
            } else {
                delayForm.hide();
            }
        }

        function onBatchingEnabledChanged(event) {
            batchingEnabledChanged = true;
            var currentState = event.target.value === 'on';
            Analytics.send({
                name: "jira.inform.admin.configuration.page.init",
                properties: {currentState: currentState}
            });
            toggleDelayConfigView(currentState);
        }

        function onIntervalChanged() {
            intervalChanged = true;
        }

        function savePreferences(event) {
            event.preventDefault();
            const batchingEnabled = $("#batching-switch-on").is(':checked');
            const saveIfEnabled = saveBatchingEnabled(batchingEnabled);
            const saveInterval = saveBatchingInterval(batchingEnabled);
            $.when(saveIfEnabled, saveInterval).done(setSuccessFlag).fail(setErrorFlag);
        }

        function saveBatchingEnabled(enabled) {
            if (!batchingEnabledChanged) {
                return;
            }
            return SmartAjax.makeRequest({
                url: ContextPath() + "/rest/batching/1.0/configuration/batchingEnabled",
                type: "PUT",
                data: JSON.stringify(enabled),
                dataType: "json",
                contentType: "application/json"
            }).success(function () {
                batchingEnabledChanged = false;
                var status = enabled ? 'in' : 'out';
                Analytics.send({name: "jira.inform.admin.configuration.opt" + status});
                Logger.trace("batching.switched");
            });
        }

        function saveBatchingInterval(batchingEnabled) {
            if (!batchingEnabled || !intervalChanged) {
                return;
            }
            const interval = $('#custom-interval').val();
            return SmartAjax.makeRequest({
                url: ContextPath() + "/rest/batching/1.0/configuration/interval",
                type: "PUT",
                data: interval,
                dataType: "json",
                contentType: "application/json"
            }).success(function () {
                intervalChanged = false;
                Analytics.send({name: "jira.inform.batcher.interval.set", properties: {interval: interval}});
                Logger.trace("interval.switched");
            })
        }

        function setSuccessFlag() {
            JiraFlag.showSuccessMsg(null, formatter.I18n.getText("jira.inform.admin.saved.successfully"));
        }

        function setErrorFlag() {
            JiraFlag.showErrorMsg("", formatter.I18n.getText("jira.inform.admin.couldnt.change.value"));
        }
    });
});
